VehicleManager_DisplaySetGet = {};

--by VehicleInspector--
--new VI--
VehicleManager_DisplaySetGet.otherSchemaIcons = {
	beetvehicles="harvester_other", potatovehicles="harvester_other", cottonvehicles="harvester_cotton", grapevehicles="harvester_other", olivevehicles="harvester_other",cottonharvester="harvester_cotton", combinecutterfruitpreparer="harvester_other", sugarcanevehicles="harvester_sugarcane",
	conveyorbelt="implement_conveyorbelt", pickupconveyorbelt="implement_conveyorbelt", selfpropelledmower="selfpropelledmower", handtoolmower="handtoolmower", selfpropelledsprayer="selfpropelledsprayer", teleloadervehicles="teleloader", wheelloadervehicles="wheelloader", forklifts="stapler", skidsteervehicles="skidsteer",
	frontloadervehicles="wheelloader", loadervehicles="wheelloader", loadervehicle="wheelloader", forageharvesters="harvester_chaff", miscvehicles="miscvehicles"
};

function VehicleManager_DisplaySetGet:getVehicleTypIconBySchema(vehicle)	
	local typIcon = "tractor_other";
	if vehicle.trainSystem ~= nil then return "train";end;
	if vehicle.spec_rideable ~= nil then return "horse";end;
	if vehicle ~= nil and vehicle.schemaOverlay ~= nil then		
		local foundOtherSchema = false;
		typIcon = vehicle.schemaOverlay.schemaName;
		if typIcon == "DEFAULT_IMPLEMENT" then
			typIcon = "IMPLEMENT";
		elseif typIcon == "DEFAULT_VEHICLE" then
			typIcon = "VEHICLE";
		end;
		if typIcon == nil or not typIcon or typIcon == "" then
			typIcon = "tractor_other";
		end;
		if typIcon == "IMPLEMENT" then
			typIcon = "implement_unknown";		
		end;
		if typIcon == "MOTORBIKE" then typIcon = "bike";end;
		if typIcon == "VEHICLE" then typIcon = "tractor";end;		
		function searchSpecialSchema(int)			
			if vehicle.spec_fillUnit ~= nil and vehicle.spec_fillUnit.fillUnits ~= nil and vehicle.spec_fillUnit.fillUnits[1] ~= nil and vehicle.spec_fillUnit.fillUnits[1].fillType ~= nil then
				local fillUnit = vehicle.spec_fillUnit.fillUnits[1];
				local fillType = fillUnit.fillType;
				if fillType == FillType.UNKNOWN and table.size(fillUnit.supportedFillTypes) == 1 then
					fillType = next(fillUnit.supportedFillTypes);
				end;			
				if int == 1 and fillType == FillType.SUGARCANE then foundOtherSchema = true;typIcon = "harvester_sugarcane";	
				elseif int == 2 and fillType == FillType.CHAFF then foundOtherSchema = true;typIcon = "harvester_chaff";
				elseif int == 2 and (fillType == FillType.UNKNOWN or fillType == FillType.SILAGE_ADDITIVE) then 					
					for fillTypeS, accepts in pairs(fillUnit.supportedFillTypes) do
						if accepts then
							if fillTypeS == FillType.GRASS or fillTypeS == FillType.WOODCHIPS then
								
							elseif fillTypeS == FillType.CHAFF then 
								typIcon = "harvester_chaff";
								foundOtherSchema = true;
								break;							
							end;								
						end;
					end;										
				end;
			end;
		end;		
		if typIcon == "HARVESTER" then						
			if vehicle.typeName ~= nil then
				if vehicle.typeName:lower() == "combinecutterfruitpreparer" then searchSpecialSchema(1);elseif vehicle.typeName:lower() == "combinedrivable" then searchSpecialSchema(2);end;				
			end;
		end;			
		if not foundOtherSchema and vehicle.typeName ~= nil then if VehicleManager_DisplaySetGet.otherSchemaIcons[vehicle.typeName:lower()] ~= nil then typIcon = VehicleManager_DisplaySetGet.otherSchemaIcons[vehicle.typeName:lower()];foundOtherSchema = true;end;end;
		if not foundOtherSchema then
			local item = g_storeManager:getItemByXMLFilename(vehicle.configFileName);
			if item ~= nil and item.categoryName ~= nil then if VehicleManager_DisplaySetGet.otherSchemaIcons[item.categoryName:lower()] ~= nil then typIcon = VehicleManager_DisplaySetGet.otherSchemaIcons[item.categoryName:lower()];foundOtherSchema = true;end;end;
		end;		
	end;
	return typIcon:lower();
end;
--new VI--

--old VI--
VehicleManager_DisplaySetGet.vehicleTypeCategory = {		
	tractor = {"tractor", "tractors", "tractorss", "tractorsm", "tractorsl"};
	harvester = {"harvester", "harvesters", "beetvehicles", "potatovehicles", "cottonvehicles", "grapevehicles", "olivevehicles", "sprayervehicles", "sugarcanevehicles", "combinedrivable", "combine", "combinecutterfruitpreparer", "cottonharvester"};
	truck = {"truck", "trucks"};
	tractor_other = {"miscvehicles", "woodharvesting", "animalvehicles", "forageharvesters"};
	teleloader = {"loadervehicle", "loadervehicles", "wheelloadervehicles", "teleloadervehicles", "skidsteervehicles", "forklifts", "frontloadervehicles"};
	car = {"car", "cars"};
	train = {"locomotive"};
};

function VehicleManager_DisplaySetGet:getIconVehicleTypByTypeDesc(vehicle)
	local categoryName = "tractor_other";	
	if vehicle ~= nil and vehicle.type ~= nil and vehicle.type.name ~= nil then
		local typeDesc = tostring(string.lower(vehicle.type.name));
		for key, value in pairs(VehicleManager_DisplaySetGet.vehicleTypeCategory) do
			for k,v in pairs(value) do
				if v.. "_" == typeDesc.. "_" or string.find(typeDesc, key) then return tostring(key);end;				
			end;
		end;
	end;	
	return categoryName;
end;
--old VI--
--by VehicleInspector--

function VehicleManager_DisplaySetGet:loadFillTypesIcons()
	g_currentMission.hlUtils.loadFillTypesOverlays();	
end;

function VehicleManager_DisplaySetGet:loadHudIcons(hud) -- + box icons in global table
	--for ad hud--
	local firstIcon, lastIcon = g_currentMission.hlUtils.insertIcons( {xmlTagName="vm_display.adHudIcons64", modDir=VehicleManager_Display.modDir, iconFile="hlHudSystem/icons/icons.dds", xmlFile="icons_vmdisplay/icons.xml", modName="VehicleManager_Display", groupName="adHud", fileFormat={64,512,1024}} );	
	--for ad hud--
	if hud.overlays.modIcons == nil then hud.overlays.modIcons = {byName={}};end;
	firstIcon, lastIcon = g_currentMission.hlUtils.insertIcons( {xmlTagName="vm_display.hudIcons", modDir=VehicleManager_Display.modDir, iconFile="icons_vmdisplay/icons.dds", xmlFile="icons_vmdisplay/icons.xml", modName="VehicleManager_Display", groupName="hud", fileFormat={64,128,128}, iconTable=hud.overlays.modIcons} );
end;

function VehicleManager_DisplaySetGet:loadBoxIcons(box)
	if box.overlays.icons == nil then box.overlays.icons = {byName={}};end;
	local firstIcon, lastIcon = g_currentMission.hlUtils.insertIcons( {xmlTagName="vm_display.boxIcons_32", modDir=VehicleManager_Display.modDir, iconFile="icons_vmdisplay/icons.dds", xmlFile="icons_vmdisplay/icons.xml", modName="defaultIcons", groupName="box", fileFormat={32,128,128}, iconTable=box.overlays.icons} );
	
	local firstIcon, lastIcon = g_currentMission.hlUtils.insertIcons( {xmlTagName="vm_display.boxIcons64", modDir=VehicleManager_Display.modDir, iconFile="hlHudSystem/icons/icons.dds", xmlFile="icons_vmdisplay/icons.xml", modName="defaultIcons", groupName="box", fileFormat={64,512,1024}, iconTable=box.overlays.icons} );
	if VehicleManager_Display.vehicleInspector then --set icon color here
		local newVersion = g_currentMission.hlUtils.modLoaded["FS25_VehicleInspector"] ~= nil;
		local overlayDefaultGroup = box.overlays.icons["defaultIcons"]["box"];
		local overlayDefaultByName = box.overlays.icons.byName["defaultIcons"]["box"];
		local overlay = overlayDefaultGroup[overlayDefaultByName["markedVehicle"]];
		if overlay ~= nil then 
			local iconColor = nil;
			if newVersion then
				iconColor = g_currentMission.hlUtils.globalFunction["FS25_VehicleInspector"].getShowColors( {showColors="marked"} );				
			else
				iconColor = g_currentMission.vehicleInspector.showColor.selected;				
			end;
			if iconColor == nil then iconColor = "mangenta";end; --default
			VehicleManager_Display.values.viMarkersColors = iconColor;
			g_currentMission.hlUtils.setBackgroundColor(overlay, g_currentMission.hlUtils.getColor(iconColor, true));
		end;		
	end;
		
	firstIcon, lastIcon = g_currentMission.hlUtils.insertIcons( {xmlTagName="vm_display.colorIcons32", modDir=VehicleManager_Display.modDir, iconFile="hlHudSystem/icons/colorIcons.dds", xmlFile="icons_vmdisplay/icons.xml", modName="defaultIcons", groupName="box", fileFormat={32,128,256}, iconTable=box.overlays.icons} );
	
	firstIcon, lastIcon = g_currentMission.hlUtils.insertIcons( {xmlTagName="vm_display.otherIcons32", modDir=VehicleManager_Display.modDir, iconFile="hlHudSystem/icons/otherIcons.dds", xmlFile="icons_vmdisplay/icons.xml", modName="defaultIcons", groupName="box", fileFormat={32,256,512}, iconTable=box.overlays.icons} );	
	
	firstIcon, lastIcon = g_currentMission.hlUtils.insertIcons( {xmlTagName="vm_display.other1Icons32", modDir=VehicleManager_Display.modDir, iconFile="hlHudSystem/icons/other1Icons.dds", xmlFile="icons_vmdisplay/icons.xml", modName="defaultIcons", groupName="box", fileFormat={32,256,512}, iconTable=box.overlays.icons} );
	
end;

function VehicleManager_DisplaySetGet:loadVehicleOverlay(vehicle)
	if vehicle ~= nil then
		local storeItem = g_storeManager:getItemByXMLFilename(vehicle.configFileName)
		if storeItem ~= nil then
			local isLoad = g_currentMission.hlUtils.loadVehicleOverlay(nil, storeItem);		
		end;
	end;
end;

function VehicleManager_DisplaySetGet:resetAllData()

end;

function VehicleManager_DisplaySetGet:isSaved(vehicle)
	return true; --patch 1.7.0x error --> vehicle.loadCallbackFunction.savegameData ~= nil;	
	--VehicleManager_Display.testString[1] = "savingMinEndTime: ".. tostring(g_currentMission.savingMinEndTime)
	--VehicleManager_Display.testString[2] = "operatingTime: ".. tostring(vehicle.operatingTime)
	--if vehicle.operatingTime == nil or g_currentMission.gameStatsTime < vehicle.operatingTime then isVehicleSave = false;end;
end;

function VehicleManager_DisplaySetGet:searchGhostVehicles()
	if vmControl.values.timer <= 0 then vmControl.values.timer = vmControl.values.searchGhostVehicles;if not vmControl.values.firstLoadTimer then vmControl:searchGhostVehicles();end;end;
	vmControl.values.firstLoadTimer = true;
	vmControl.values.timer = vmControl.values.timer-1;
end;

function VehicleManager_DisplaySetGet:setViewGroupsBox(box)
	VehicleManager_DisplaySetGet:searchGhostVehicles();
	local playerFarmId = g_currentMission.hlUtils.getPlayerFarmId();
	local viewGroups = {};
	local vehiclesSortByGroup = {};
	local values = box.ownTable;
	local valuesGlobal = vmGroups.values;
	local openGroups = false;
	
	local ghostVehicles = {};
	
	if #vmGroups.values.groups > 0 then
		function sortVehicles()
			--sort by Name--
			if #vehiclesSortByGroup > 0 then
				function comp(w1,w2)			
					return w1.sortBy < w2.sortBy;
				end;	
				table.sort(vehiclesSortByGroup, comp);
				table.foreach(vehiclesSortByGroup, function(k, v) table.insert(viewGroups, v) end);
			end;
			--sort by Name
		end;
		for g=1, #vmGroups.values.groups do
			local group = vmGroups.values.groups[g];
			viewGroups[#viewGroups+1] = {};
			local typIdLength = vmGroups:getTypIdLength(group.typId);
			viewGroups[#viewGroups] = {name=group.name, isGroup=true, group=g, hasUgroups=#group.uGroups > 0 ,isUgroup=false, isVehicle=false, isMission=group.missionId, viewOpen=group.viewOpen, viewTyp=group.viewTyp, typIdLength=typIdLength, typIdLengthUgroups=0, isHelper=false, isPlayer=false, isOtherPlayer=false};
			local mergeGroup = #viewGroups;
			if group.viewOpen then --groups vehicles				
				openGroups = true;
				if not box.isSetting and typIdLength > 0 then
					vehiclesSortByGroup = {};
					for typId, v in pairs(group.typId) do
						if v ~= nil and v.node ~= nil then						
							local isChange = false;
							local vehicle = g_currentMission.nodeToObject[v.node];
							if vehicle == nil then vehicle = g_currentMission.nodeToObject[vmControl:getNodeByTypId(typId)];if vehicle ~= nil then v.node = vehicle.rootNode;isChange=true;if g_dedicatedServer == nil then VehicleManager_DisplaySetGet:loadVehicleOverlay(vehicle);end;end;end; --change 1
							if vehicle == nil then vehicle = g_currentMission.nodeToObject[vmControl:searchNodeByTypId(typId)];if vehicle ~= nil then v.node = vehicle.rootNode;isChange=true;vmControl:setNodeByTypId(typId, vehicle.rootNode);if g_dedicatedServer == nil then VehicleManager_DisplaySetGet:loadVehicleOverlay(vehicle);end;end;end; --change 2 !!!!!
							if vehicle ~= nil then
								if not VehicleManager_Display.vehicleInspector and vehicle.vmTypIcon == nil then vehicle.vmTypIcon = VehicleManager_DisplaySetGet:getVehicleTypIconBySchema(vehicle);end;
								local vehicleName = VehicleManager_DisplaySetGet:getVehicleName(vehicle, values.view.vehicleName);
								local driverName = VehicleManager_DisplaySetGet:getDriverName(vehicle, values.view.vehicleName);									
								local isContractorVehicle = VehicleManager_DisplaySetGet:getContractorFarm(playerFarmId, vehicle.ownerFarmId);								
								local isHelper, isPlayer, isOtherPlayer = false,false,false;
								if VehicleManager_DisplaySetGet:isControlledByTypId(typId) then
									isHelper, isPlayer, isOtherPlayer, _ = VehicleManager_DisplaySetGet:getControlledAllWho(nil, typId);
								end;
								if isHelper or isPlayer or isOtherPlayer then
									if not viewGroups[mergeGroup].isHelper and isHelper then viewGroups[mergeGroup].isHelper = isHelper;end;
									if not viewGroups[mergeGroup].isPlayer and isPlayer then viewGroups[mergeGroup].isPlayer = isPlayer;end;
									if not viewGroups[mergeGroup].isOtherPlayer and isOtherPlayer then viewGroups[mergeGroup].isOtherPlayer = isOtherPlayer;end;
								end;
								if v.storeName == "Unknown Name" or isChange then v.storeName = VehicleManager_DisplaySetGet:getStoreItemName(v.node);end; --change
								--if vehicleName == nil or vehicleName:len() == 0 then vehicleName = v.storeName;end;
								vehiclesSortByGroup[#vehiclesSortByGroup+1] = {sortBy=vehicleName, vehicleName=vehicleName, name=v.storeName, driverName=driverName, isGroup=false, group=g, hasUgroups=#group.uGroups > 0, isUgroup=false, isVehicle=true, isGroupVehicle=true, isUgroupVehicle=false, typId=typId, node=v.node, isFarmVehicle=playerFarmId==vehicle.ownerFarmId, isContractorVehicle=isContractorVehicle, isHelper=isHelper, isPlayer=isPlayer, isOtherPlayer=isOtherPlayer};
								if values.view.vehicleName[1] > 1 and values.view.vehicleName[1] ~= 5 and values.view.combiVehicleName[1] > 1 and driverName ~= nil and vehicleName ~= nil then
									if values.view.combiVehicleName[1] == 2 then 
										vehiclesSortByGroup[#vehiclesSortByGroup].sortBy = vehicleName.. tostring(box.ownTable.viewText.combiVehicleNameSeparator).. driverName;
									elseif values.view.combiVehicleName[1] == 3 then
										vehiclesSortByGroup[#vehiclesSortByGroup].sortBy = driverName.. tostring(box.ownTable.viewText.combiVehicleNameSeparator).. vehicleName;
									end;
								elseif values.view.vehicleName[1] > 1 or vehiclesSortByGroup[#vehiclesSortByGroup].sortBy == nil then
									if vehicleName ~= nil then vehiclesSortByGroup[#vehiclesSortByGroup].sortBy = vehicleName;else vehiclesSortByGroup[#vehiclesSortByGroup].sortBy = vehiclesSortByGroup[#vehiclesSortByGroup].name or "";end;
								end;
							else
								ghostVehicles[typId] = {};							
							end;							
						end;	
					end;
					sortVehicles();
				end;
				if #group.uGroups > 0 then
					openGroups = true;
					for ug=1, #group.uGroups do
						local uGroup = group.uGroups[ug];						
						viewGroups[#viewGroups+1] = {};
						typIdLength = vmGroups:getTypIdLength(uGroup.typId);
						viewGroups[#viewGroups] = {name=uGroup.name, isGroup=false, group=g, isUgroup=true, uGroup=ug, isVehicle=false, viewOpen=uGroup.viewOpen, viewTyp=uGroup.viewTyp, typIdLength=typIdLength, isHelper=false, isPlayer=false, isOtherPlayer=false};
						local mergeUgroup = #viewGroups;
						if uGroup.viewOpen and typIdLength > 0 and not box.isSetting then --uGroups vehicles
							openGroups = true;
							vehiclesSortByGroup = {};
							for typId, v in pairs(uGroup.typId) do
								if v ~= nil and v.node ~= nil then
									local isChange = false;
									local vehicle = g_currentMission.nodeToObject[v.node];
									if vehicle == nil then vehicle = g_currentMission.nodeToObject[vmControl:getNodeByTypId(typId)];if vehicle ~= nil then v.node = vehicle.rootNode;isChange=true;if g_dedicatedServer == nil then VehicleManager_DisplaySetGet:loadVehicleOverlay(vehicle);end;end;end; --change 1
									if vehicle == nil then vehicle = g_currentMission.nodeToObject[vmControl:searchNodeByTypId(typId)];if vehicle ~= nil then v.node = vehicle.rootNode;isChange=true;vmControl:setNodeByTypId(typId, vehicle.rootNode);if g_dedicatedServer == nil then VehicleManager_DisplaySetGet:loadVehicleOverlay(vehicle);end;end;end; --change 2 !!!!!
									if vehicle ~= nil then									
										if not VehicleManager_Display.vehicleInspector and vehicle.vmTypIcon == nil then vehicle.vmTypIcon = VehicleManager_DisplaySetGet:getVehicleTypIconBySchema(vehicle);end;
										local vehicleName = VehicleManager_DisplaySetGet:getVehicleName(vehicle, values.view.vehicleName);
										local driverName = VehicleManager_DisplaySetGet:getDriverName(vehicle, values.view.vehicleName);																				
										local isContractorVehicle = VehicleManager_DisplaySetGet:getContractorFarm(playerFarmId, vehicle.ownerFarmId);										
										local isHelper, isPlayer, isOtherPlayer = false,false,false;
										if VehicleManager_DisplaySetGet:isControlledByTypId(typId) then
											isHelper, isPlayer, isOtherPlayer, _ = VehicleManager_DisplaySetGet:getControlledAllWho(nil, typId);
										end;
										if isHelper or isPlayer or isOtherPlayer then
											if not viewGroups[mergeUgroup].isHelper and isHelper then viewGroups[mergeUgroup].isHelper = isHelper;end;
											if not viewGroups[mergeUgroup].isPlayer and isPlayer then viewGroups[mergeUgroup].isPlayer = isPlayer;end;
											if not viewGroups[mergeUgroup].isOtherPlayer and isOtherPlayer then viewGroups[mergeUgroup].isOtherPlayer = isOtherPlayer;end;
										end;									
										if v.storeName == "Unknown Name" or isChange then v.storeName = VehicleManager_DisplaySetGet:getStoreItemName(v.node);end; --change
										--if vehicleName == nil or vehicleName:len() == 0 then vehicleName = v.storeName;end;
										vehiclesSortByGroup[#vehiclesSortByGroup+1] = {sortBy=vehicleName, vehicleName=vehicleName, name=v.storeName, driverName=driverName, isGroup=false, group=g, isUgroup=false, uGroup=ug, isVehicle=true, isGroupVehicle=false, isUgroupVehicle=true, typId=typId, node=v.node, isFarmVehicle=playerFarmId==vehicle.ownerFarmId, isContractorVehicle=isContractorVehicle, isHelper=isHelper, isPlayer=isPlayer, isOtherPlayer=isOtherPlayer};
										if values.view.vehicleName[1] > 1 and values.view.vehicleName[1] ~= 5 and values.view.combiVehicleName[1] > 1 and driverName ~= nil and vehicleName ~= nil then
											if values.view.combiVehicleName[1] == 2 then 
												vehiclesSortByGroup[#vehiclesSortByGroup].sortBy = vehicleName.. tostring(box.ownTable.viewText.combiVehicleNameSeparator).. driverName;
											elseif values.view.combiVehicleName[1] == 3 then
												vehiclesSortByGroup[#vehiclesSortByGroup].sortBy = driverName.. tostring(box.ownTable.viewText.combiVehicleNameSeparator).. vehicleName;
											end;
										elseif values.view.vehicleName[1] > 1 or vehiclesSortByGroup[#vehiclesSortByGroup].sortBy == nil then
											if vehicleName ~= nil then vehiclesSortByGroup[#vehiclesSortByGroup].sortBy = vehicleName;else vehiclesSortByGroup[#vehiclesSortByGroup].sortBy = vehiclesSortByGroup[#vehiclesSortByGroup].name or "";end;
										end;
									else										
										ghostVehicles[typId] = {};									
									end;
								end;	
							end;
							sortVehicles();
						elseif values.view.driverActiveIcon[1] > 1 and not box.isSetting and typIdLength > 0 then
							local isHelper, isPlayer, isOtherPlayer = VehicleManager_DisplaySetGet:isHelperOrPlayer(g, ug);
							if isHelper or isPlayer or isOtherPlayer then
								viewGroups[mergeUgroup].isHelper = isHelper;
								viewGroups[mergeUgroup].isPlayer = isPlayer;
								viewGroups[mergeUgroup].isOtherPlayer = isOtherPlayer;
							end;
						end;
					end;
				end;
			elseif values.view.driverActiveIcon[1] > 1 and not box.isSetting and (typIdLength > 0 or #group.uGroups > 0) then
				local isHelper, isPlayer, isOtherPlayer = VehicleManager_DisplaySetGet:isHelperOrPlayer(g);
				if isHelper or isPlayer or isOtherPlayer then
					viewGroups[mergeGroup].isHelper = isHelper;
					viewGroups[mergeGroup].isPlayer = isPlayer;
					viewGroups[mergeGroup].isOtherPlayer = isOtherPlayer;
				end;
			end;
			if not box.isSetting and not group.viewOpen and #group.uGroups > 0 then
				viewGroups[mergeGroup].typIdLengthUgroups = vmGroups:getTypIdLengthAllUGroups(g);				
			end;
		end;	
	end;
	for typId, _ in pairs(ghostVehicles) do
		vmGroups:delVehicleAtGroups(typId);
	end;
	VehicleManager_Display.viewGroupsBox = viewGroups;
	return openGroups;
end;

function VehicleManager_DisplaySetGet:setForceMouseOff()	
	g_currentMission.hlUtils.mouseOnOff(false, false); --force mouseOff
end;

function VehicleManager_DisplaySetGet:getStoreItemName(vehicleNode)	
	local storeName = "VehicleName Unknown";
	local vehicle = g_currentMission.nodeToObject[vehicleNode];
	if vehicle ~= nil then
		local storeItem = g_storeManager:getItemByXMLFilename(vehicle.configFileName);
		if storeItem ~= nil then storeName = storeItem.name;end;
		if storeName == nil then storeName = "VehicleName Unknown";end;
	end;
	return storeName;
end;

function VehicleManager_DisplaySetGet:getDriverName(vehicle, values)	
	if vehicle ~= nil and values[1] > 1 then		
		local driverName = nil;	
		if vehicle.ad ~= nil and vehicle.ad.stateModule ~= nil then
			driverName = vehicle.ad.stateModule:getName();
		elseif not VehicleManager_Display.autoDrive.loaded and vehicle.vmControl ~= nil then
			driverName = vehicle.vmControl.driverName;
			if driverName == nil then driverName = vmControl:getDriverNameByTypId(vehicle.vmControl.typId);end;
		end;		
		if driverName ~= nil and driverName:len() > 0 then		
			return driverName;
		end;	
	end;	
	return nil;
end;

function VehicleManager_DisplaySetGet:clickVehicleName(mouseClick, vehicleNode, mouseOff)
	local vehicle = g_currentMission.nodeToObject[vehicleNode];
	if vehicle ~= nil then
		if mouseClick == "right" then
			local vehicleName = tostring(vehicle.getName(vehicle));
			--g_currentMission.hlUtils.addTextDisplay( {txt="RightClick: ".. tostring(vehicleName), txtBold=true, duration=3} );
			if g_currentMission.hlHudSystem.camera.active and g_currentMission.hlHudSystem.camera.node ~= 0 then
				local box = g_currentMission.hlHudSystem.hlBox:getData("VehicleManager_Display_Box");
				local camBox = g_currentMission.hlHudSystem.hlBox:getData("hlHudSystem_CameraBox");
				if box ~= nil and camBox ~= nil then
					if g_currentMission.hlHudSystem.camera.object.node == 0 or g_currentMission.hlHudSystem.camera.object.node ~= vehicleNode then
						g_currentMission.hlHudSystem.camBox.setObject( {node=vehicleNode, isVehicle=true, camZoom=box.ownTable.camera.zoom[1], camRotation={box.ownTable.camera.rotX[1]}} ); --onClick=VehicleInspector_Display_MouseKeyEventsBox.onClickCamBox
						g_currentMission.hlHudSystem.camBox.setShow(true);
					elseif g_currentMission.hlHudSystem.camera.object.node == vehicleNode then
						g_currentMission.hlHudSystem.camBox.setShow(false);
					end;
				end;
			elseif not g_currentMission.hlHudSystem.camera.active then
				g_currentMission.hlHudSystem.showInfoBox( {"CamBox... ".. g_i18n:getText("noConvertLs25"), 3000, g_currentMission.hlUtils.getColor("orangeRed", true)} );							
			end;
		elseif mouseClick == "left" then
			VehicleManager_DisplaySetGet:clickVehicleJoin(vehicle, mouseOff);
		end;
	end;
end;

function VehicleManager_DisplaySetGet:clickVehicleJoin(vehicle, mouseOff) 
	if vehicle == nil then return;end;
	if g_localPlayer == nil or g_localPlayer.getCurrentVehicle == nil or g_localPlayer:getCurrentVehicle() == vehicle then return;end;		
	if vehicle.getIsControlled ~= nil and vehicle.getIsControlled(vehicle) then g_currentMission.hlUtils.addTextDisplay( {txt=g_i18n:getText("shop_messageIsInUse"), txtBold=true, duration=3, warning=true} );return;end;
	if vehicle.getIsEnterable ~= nil and vehicle:getIsEnterable() then		
		if mouseOff == nil or mouseOff then VehicleManager_DisplaySetGet:setForceMouseOff();end;
		g_localPlayer:requestToEnterVehicle(vehicle);		
		return;
	end;
	return;	
end;

function VehicleManager_DisplaySetGet:setControlledVehicles() --all collect helpers,player,otherPlayers global
	if g_currentMission ~= nil and g_currentMission.vehicleSystem ~= nil and g_currentMission.vehicleSystem.enterables ~= nil then
		vmGroups.values.controlledVehicles ={typId={},node={}}; --reset
		for v=1, #g_currentMission.vehicleSystem.enterables do
			local vehicle = g_currentMission.vehicleSystem.enterables[v];			
			if vehicle ~= nil and vehicle.finishedLoading == true and vehicle.getIsControlled ~= nil and vehicle.vmControl ~= nil and vehicle.vmControl.typId ~= nil and vehicle.vmControl.typId > 0 then
				local controlledName, isOtherPlayer = VehicleManager_DisplaySetGet:getPlayerName(vehicle);
				local isHelper = VehicleManager_DisplaySetGet:isHelper(vehicle);
				local isPlayer = controlledName:len() > 0 and isOtherPlayer == false;
				if isHelper or isPlayer or isOtherPlayer then
					vmGroups.values.controlledVehicles.typId[vehicle.vmControl.typId] = {isHelper=isHelper,isPlayer=isPlayer,isOtherPlayer=isOtherPlayer,controlledName=controlledName};
					vmGroups.values.controlledVehicles.node[vehicle.rootNode or 0] = {isHelper=isHelper,isPlayer=isPlayer,isOtherPlayer=isOtherPlayer,controlledName=controlledName};
				end;
			end;
		end;
	else
		vmGroups.values.controlledVehicles ={typId={},node={}};
	end;
end;

function VehicleManager_DisplaySetGet:isControlledByNode(vehicleNode)
	if vehicleNode == nil then return false;end;
	return vmGroups.values.controlledVehicles.node[vehicleNode] ~= nil;
end;

function VehicleManager_DisplaySetGet:isControlledByTypId(typId)
	if typId == nil then return false;end;
	return vmGroups.values.controlledVehicles.typId[typId] ~= nil;
end;

function VehicleManager_DisplaySetGet:getControlledWho(vehicleNode, typId)
	if vehicleNode == nil and typId == nil then return;end;
	if vehicleNode ~= nil then return vmGroups.values.controlledVehicles.node[vehicleNode];end;
	if typId ~= nil then return vmGroups.values.controlledVehicles.typeId[typId];end;
	return;
end;

function VehicleManager_DisplaySetGet:getControlledAllWho(vehicleNode, typId)
	if vehicleNode == nil and typId == nil then return;end;
	if vehicleNode ~= nil then
		local c = vmGroups.values.controlledVehicles.node[vehicleNode];
		if c ~= nil then return c.isHelper, c.isPlayer, c.isOtherPlayer, c.controlledName;else return;end;
	end;
	if typId ~= nil then
		local c = vmGroups.values.controlledVehicles.typId[typId];
		if c ~= nil then return c.isHelper, c.isPlayer, c.isOtherPlayer, c.controlledName;else return;end;
	end;
	return;
end;

function VehicleManager_DisplaySetGet:getContractorFarm(playerFarmId, vehicleFarmId)
	if not g_currentMission.missionDynamicInfo.isMultiplayer then return false;end;	
	local farm = g_farmManager:getFarmById(playerFarmId);
	if farm ~= nil then
		return farm:getIsContractingFor(vehicleFarmId); 
	end;
	return false;
end;

function VehicleManager_DisplaySetGet:isHelperOrPlayer(group, uGroup)
	local group = vmGroups.values.groups[group];
	if uGroup ~= nil then group = group.uGroups[uGroup];end;	
	if group == nil or group.viewOpen then return false, false, false;end;	
	if uGroup == nil and group.typId == nil then return false, false, false;end;
	
	if vmGroups:getTypIdLength(vmGroups.values.controlledVehicles.typId) == 0 then return false, false, false;end;
	
	local isHelpers = false;
	local isPlayers = false;
	local isOtherPlayers = false;
	for typId, v in pairs(group.typId) do
		if VehicleManager_DisplaySetGet:isControlledByTypId(typId) then
			isHelpers, isPlayers, isOtherPlayers, _ = VehicleManager_DisplaySetGet:getControlledAllWho(nil, typId);
			if isHelpers ~= nil then break;end;
		end;
	end;
	if uGroup == nil and not isHelpers and not isPlayers and not isOtherPlayers then
		if #group.uGroups > 0 then
			for ug=1, #group.uGroups do
				uGroup = group.uGroups[ug];
				if uGroup ~= nil and uGroup.typId ~= nil and (not uGroup.viewOpen or not group.viewOpen) then
					for typId, v in pairs(uGroup.typId) do
						if VehicleManager_DisplaySetGet:isControlledByTypId(typId) then
							isHelpers, isPlayers, isOtherPlayers, _ = VehicleManager_DisplaySetGet:getControlledAllWho(nil, typId);
							if isHelpers ~= nil then break;end;						
						end;
					end;
				end;
			end;
		end;
	end;
	return isHelpers or false, isPlayers or false, isOtherPlayers or false;
end;

function VehicleManager_DisplaySetGet:vehicleInfos(vehicle, box)
	if VehicleManager_Display.values.showVehicleInfos and vehicle ~= nil and vehicle.spec_enterable ~= nil and vehicle.vmControl ~= nil and vehicle.vmControl.typId ~= nil and box ~= nil then
		
		--box:addLine(g_i18n:getText(""), "");
	end;
end;

function VehicleManager_DisplaySetGet.showVehicleInfo(self)
	if VehicleManager_Display:getDetiServer() then return;end;
	if self ~= nil and self.isVehicle then		
		VehicleManager_DisplaySetGet:vehicleInfos(self.object, self.objectBox);	
	end;
end;		

--by VehicleInspector--
function VehicleManager_DisplaySetGet:getVehicleName(vehicle, values)
	if vehicle ~= nil and values[1] > 1 then		
		local vehicleName = nil;		
		if vehicle.spec_rideable ~= nil then
			vehicleName = g_i18n:getText("fillType_horse");
		elseif vehicle.trainSystem ~= nil then
			vehicleName = g_i18n:getText("storeItem_train");
		elseif values[1] == 2 and vehicle.getName ~= nil then
			vehicleName = vehicle:getName();		
		elseif values[1] == 3 and vehicle.getFullName ~= nil then				
			vehicleName = vehicle:getFullName();		
		elseif values[1] == 4 and vehicle.typeDesc ~= nil and vehicle.typeDesc:len() > 0 then 
			vehicleName = vehicle.typeDesc;
		elseif values[1] == 5 and vehicle.ad ~= nil and vehicle.ad.stateModule ~= nil then
			vehicleName = vehicle.ad.stateModule:getName();
		elseif values[1] == 5 and vehicle.vmControl ~= nil then
			vehicleName = vehicle.vmControl.driverName;			
		end;		
		if vehicleName ~= nil and vehicleName:len() > 0 then		
			return vehicleName;
		end;		
	end;
	return nil;
end;

function VehicleManager_DisplaySetGet:getPlayerName(vehicle)	
	if vehicle.spec_enterable ~= nil and vehicle.spec_enterable.controllerUserId ~= nil then
		local user = g_currentMission.userManager:getUserByUserId(vehicle.spec_enterable.controllerUserId);
		if user ~= nil then			
			local userName = Utils.getNoNil(user:getNickname(), "P");
			return userName, userName ~= g_gameSettings.onlinePresenceName;
		end;
	end;		
	return "", false; --error	
end;

function VehicleManager_DisplaySetGet:isHelper(vehicle)
	if vehicle == nil then return false;end;
	local adErrorHelper = vehicle.getIsAIActive ~= nil and vehicle:getIsAIActive(); --for AD helper Bug Version >2.0.0.5				
	return (vehicle.getCurrentHelper ~= nil and vehicle.getCurrentHelper(vehicle)) or adErrorHelper;
end;

function VehicleManager_DisplaySetGet:getVehicleSchemaData()
	local vehicleSchema = g_currentMission.hud.inputHelp
	if vehicleSchema ~= nil and vehicleSchema.vehicle ~= nil then
		--local offsetX, offsetY = getNormalizedScreenValues(unpack(SwitchVehicleDisplay.POSITION.GAMEPAD_OFFSET));
		local posX, posY = vehicleSchema:getPosition();
		local height = vehicleSchema.lineBg.height;
		local width = vehicleSchema.lineBg.width;
		local w = vehicleSchema.maxSchemaWidth/4; 
		posX = posX;-- + (offsetX or 0);
		posY = posY-height;-- + (offsetY or 0);		
		if vehicleSchema:getVisible() then posY = posY-height;end;		
		return true, posX, posY, width, height, w, vehicleSchema:getVisible();
	end;
	return false;	
end;
--by VehicleInspector--

function VehicleManager_DisplaySetGet.addInfoMsg(args) --textticker or ...
	if args == nil or type(args) ~= "table" or args.ownTable == nil then return;end;
	local box = g_currentMission.hlHudSystem.hlBox:getData("VehicleManager_Display_Box");
	local isTextTicker = g_currentMission.hlHudSystem.textTicker ~= nil and g_currentMission.hlHudSystem.textTicker.isOn;
	if box ~= nil and not box.isHidden() then --check player hidden mod after.. ?
		if args.ownTable[1] == "vm_boxEditModus_" and box.ownTable.modus[1] == 2 then
			if isTextTicker then	
				g_currentMission.hlHudSystem.textTicker:addMsg( {text=g_i18n:getText("box_modus2_onWarning"),color=box.overlays.color.columTitle} );
			else
				g_currentMission.hlUtils.addTextDisplay( {txt=g_i18n:getText("box_modus2_onWarning"), txtBold=true, duration=5, txtColor="orangeRed"} );
			end;
		end;
	end;
end;