VehicleManager_Display_DrawBox = {};

function VehicleManager_Display_DrawBox.setBox(args)
	if args == nil or type(args) ~= "table" or args.typPos == nil or args.inArea == nil then return;end;
	local box = g_currentMission.hlHudSystem.box[args.typPos];
	if box == nil then return;end;
		
	local inArea = args.inArea
	local boxNumber = args.typPos;
	
	local x, y, w, h = box:getScreen();	
	
	local mW = w/2;
	local mH = h/2;
	
	local distance = box:getSize( {"distance"} ); 
	local difW = distance.textWidth --default width
	local difH = distance.textHeight; --default height	
	local size = box.screen.size.zoomOutIn.text[1];
	local difSize = 0.0015;
	
	local overlayFillTypesGroup = g_currentMission.hlUtils.overlays["LS_FillTypes"]["fillTypes"];
	local overlayFillTypesByName = g_currentMission.hlUtils.overlays.byName["LS_FillTypes"]["fillTypes"];	
	local overlayDefaultGroup = box.overlays.icons["defaultIcons"]["box"];
	local overlayDefaultByName = box.overlays.icons.byName["defaultIcons"]["box"];
	local overlay = nil;
	local tempOverlay = nil;
	local typOverlay = nil;
	local classOverlay = nil;	
	local uGroupSeparator = tostring(box.ownTable.viewText.uGroupSeparator);
	
	--local uGroupMarkerOpen = KeyboardHelper.getDisplayKeyName(274.0);
	--local uGroupMarkerClose = KeyboardHelper.getDisplayKeyName(273.0);
	
	function needsUpdate()		
		if box.needsUpdate or box.ownTable.lineHeight == nil then			
			box.ownTable.lineHeight = getTextHeight(size, utf8Substr("Äg", 0))+distance.textLine;
			box.ownTable.iconWidth, box.ownTable.iconHeight = box:getOptiWidthHeight( {typ="icon", height=box.ownTable.lineHeight-distance.textLine-(difH), width=w-(difW*2)} );
			--box.ownTable.sizeTextIcon = box.screen:getOptiSizeText( {typ="text", text="P", height=box.ownTable.iconHeight} );
		end;		
		box.needsUpdate = false;
	end;	
	needsUpdate();
	
	if not g_currentMission.hlUtils.isMouseCursor then box.isSetting = false;end;	
	if box.isSetting then box.ownTable.modus[1] = 1;end;	
	
	local profileSetting = box.isSetting and box.settingTyp == 3;
	
	--local playerFarmId = g_currentMission.hlUtils.getPlayerFarmId();
	local iconColor = nil;
	local iconWidth = box.ownTable.iconWidth;
	local iconHeight = box.ownTable.iconHeight;
	local iconWidthS = iconWidth/1.3;
	local iconHeightS = iconHeight/1.3;
	local iconWidthB = iconWidth*1.3;
	local iconHeightB = iconHeight*1.3;
	local iconWidthV = iconWidth*1.8;
	local iconHeightV = iconHeight*1.8;
	local nextPosX = x+difW;
	local nextPosY = y;		
	local nextIconPosX = x+difW;
	local nextLeftPosX = nextPosX;
	local nextRightPosX = x+w-difW;
	nextPosY = nextPosY+(h)-(box.ownTable.lineHeight)-difH;
	
	VehicleManager_DisplaySetGet:setControlledVehicles(); --all collect
	
	local isOpenGroup = false;		
	local profile = nil;
	if profileSetting then		
		profile = vmGroups:getProfile();
		box.screen.bounds[4] = #profile+1;
	else		
		isOpenGroup = VehicleManager_DisplaySetGet:setViewGroupsBox(box);
		box.screen.bounds[4] = #VehicleManager_Display.viewGroupsBox+1; -- +1 for Imaginäre Line wenn untergruppe an ist		
	end;
	if box.viewExtraLine then box.screen.bounds[4] = box.screen.bounds[4]+1;end;
	
	function setInfoHelpText(txt, maxLine, txtColor) --global or mod
		if box.isSetting and box.settingTyp == 1 and g_currentMission.hlHudSystem.infoDisplay.on then --insert more text
			box:setMoreInfo(tostring(txt));
		else
			g_currentMission.hlHudSystem:addTextDisplay( {txt=tostring(txt), maxLine=maxLine, txtColor=txtColor} ); 
		end;
	end;
	
	if box.screen.bounds[1] > 0 then		
		--warningLine--
		function setWarningLineIcon()
			overlay = overlayDefaultGroup[overlayDefaultByName["right"]];
			g_currentMission.hlUtils.setOverlay(overlay, x+w-((iconWidth/1.5/2)), nextPosY-0.003, iconWidth/1.5, iconHeight/1.5);
			g_currentMission.hlUtils.setBackgroundColor(overlay, g_currentMission.hlUtils.getColor(box.overlays.color.warning, true));
			local inIconArea = overlay.mouseInArea();			
			if box.isHelp and inIconArea then setInfoHelpText(string.format(box:getI18n("hl_infoDisplay_viewNotAllIcons"), "Box"), 0);end; 
			if (g_currentMission.hlUtils.runsTimer("1sec", true) and g_currentMission.hlUtils.isMouseCursor) or (not g_currentMission.hlUtils.isMouseCursor) then
				overlay:render();
			end;
		end;
		--warningLine--
		--viewExtraLineSetting--
		function viewExtraLineSetting()
			if nextPosY < y then return;end;			
			local setWarningLine = false;
			local inIconArea = false;
			
			function getInIconArea(posX, posY, width, height)
				if not inArea then return false;end;
				overlay = box.overlays.bgLine; --hidden overlay
				if overlay ~= nil then
					g_currentMission.hlUtils.setOverlay(overlay, posX, posY or nextPosY, width, height or box.ownTable.lineHeight);
					return overlay.mouseInArea();
				end;
				return false;
			end;
			
			if not setWarningLine and nextIconPosX+iconWidth < x+w then --settingTyp switch
				overlay = overlayDefaultGroup[overlayDefaultByName["settingExtension"]];
				if Overlay ~= nil then
					g_currentMission.hlUtils.setOverlay(overlay, nextIconPosX, nextPosY, iconWidth, iconHeight);
					inIconArea = false;
					if inArea then inIconArea = overlay.mouseInArea();end;
					if inIconArea then
						g_currentMission.hlUtils.setBackgroundColor(overlay, g_currentMission.hlUtils.getColor(box.overlays.color.inArea, true));
					elseif box.guiMenu.show then 
						g_currentMission.hlUtils.setBackgroundColor(overlay, g_currentMission.hlUtils.getColor(box.overlays.color.on, true));
					else
						g_currentMission.hlUtils.setBackgroundColor(overlay, g_currentMission.hlUtils.getColor(box.overlays.color.notActive, true));
					end;					
					overlay:render();
					if box.isHelp and inIconArea then setInfoHelpText(g_i18n:getText("box_showGuiBox"), 0);end;					
					if not g_currentMission.hlUtils:disableInArea() and inArea and inIconArea then box:setClickArea( {overlay.x, overlay.x+overlay.width, overlay.y, overlay.y+overlay.height, onClick=VehicleManager_Display_MouseKeyEventsBox.onClickArea, whatClick="VehicleManager_Display_Box", typPos=boxNumber, whereClick="settingGuiBox_", ownTable={}} );end;
					nextIconPosX = nextIconPosX+iconWidth+difW;
				end;
			else
				setWarningLine = true;
			end;
			
			if not setWarningLine and nextIconPosX+iconWidth < x+w then --settingTyp switch
				overlay = overlayDefaultGroup[overlayDefaultByName["switch"]];
				if overlay ~= nil then
					g_currentMission.hlUtils.setOverlay(overlay, nextIconPosX, nextPosY, iconWidth, iconHeight);
					inIconArea = false;
					if inArea then inIconArea = overlay.mouseInArea();end;
					if inIconArea then
						g_currentMission.hlUtils.setBackgroundColor(overlay, g_currentMission.hlUtils.getColor(box.overlays.color.inArea, true));
					else
						g_currentMission.hlUtils.setBackgroundColor(overlay, g_currentMission.hlUtils.getColor(box.overlays.color.text, true));					
					end;
					overlay:render();
					if box.isHelp and inIconArea then setInfoHelpText(string.format(g_i18n:getText("box_settingSwitch"), tostring(box.settingTyp)), 0);end;					
					if not g_currentMission.hlUtils:disableInArea() and inArea and inIconArea then box:setClickArea( {overlay.x, overlay.x+overlay.width, overlay.y, overlay.y+overlay.height, onClick=VehicleManager_Display_MouseKeyEventsBox.onClickArea, whatClick="VehicleManager_Display_Box", typPos=boxNumber, whereClick="settingTyp_", ownTable={}} );end;
					nextIconPosX = nextIconPosX+iconWidth+difW;
				end;
			else
				setWarningLine = true;
			end;			
			
			if box.settingTyp > 1 then
				if not setWarningLine and nextIconPosX+iconWidth < x+w then
					local settingTyp = {[1]="",[2]="Groups: ",[3]="Profile: "};					
					local sText = tostring(tostring(settingTyp[box.settingTyp]));
					setTextColor(1, 1, 1, 1);
					renderText(nextIconPosX+difW, nextPosY, size-difSize, tostring(sText));
					local textWidth = getTextWidth(size, utf8Substr(sText, 0));
					nextIconPosX = nextIconPosX+textWidth+difW;			
				else
					setWarningLine = true;
				end;
			end;
			if box.settingTyp == 1 then
				if not setWarningLine and nextIconPosX+iconWidth < x+w then
					overlay = overlayDefaultGroup[overlayDefaultByName["lineHorizontalUpDown"]];
					tempOverlay = box.overlays.bgLine;
					if overlay ~= nil and tempOverlay ~= nil then
						g_currentMission.hlUtils.setOverlay(overlay, nextIconPosX, nextPosY, iconWidth, iconHeight);
						inIconArea = false;
						if inArea then inIconArea = overlay.mouseInArea();end;
						if inIconArea then g_currentMission.hlUtils.setBackgroundColor(overlay, g_currentMission.hlUtils.getColor(box.overlays.color.inArea, true));else g_currentMission.hlUtils.setBackgroundColor(overlay, g_currentMission.hlUtils.getColor(box.overlays.color.text, true));end;
						overlay:render();
						if box.isHelp and inIconArea then setInfoHelpText(string.format(box:getI18n("hl_infoDisplay_lineDistance"), string.format("%1.2f", box.screen.size.distance.textLine/box.screen.pixelH)));end;					
						if not g_currentMission.hlUtils:disableInArea() and inArea and inIconArea then box:setClickArea( {overlay.x, overlay.x+overlay.width, overlay.y, overlay.y+overlay.height, onClick=VehicleManager_Display_MouseKeyEventsBox.onClickArea, whatClick="VehicleManager_Display_Box", typPos=boxNumber, whereClick="settingLineDistance_", ownTable={}} );end;
						nextIconPosX = nextIconPosX+iconWidth+difW;
					end;
				else
					setWarningLine = true;
				end;						
				if not setWarningLine and nextIconPosX+(iconWidthB*3) < x+w then
					local sizeText = tostring(" |S:"..string.format("%1.1f", size*1000));
					setTextColor(1, 1, 1, 1);
					renderText(nextIconPosX+difW, nextPosY, size-difSize, tostring(sizeText));
					local textWidth = getTextWidth(size, utf8Substr(sizeText, 0));
					nextIconPosX = nextIconPosX+textWidth+difW;
				else
					setWarningLine = true;
				end;				
			end;

			if box.settingTyp == 2 then
				if not setWarningLine and nextIconPosX+iconWidth < x+w then					
					overlay = overlayDefaultGroup[overlayDefaultByName["generate"]];
					if overlay ~= nil then					
						g_currentMission.hlUtils.setOverlay(overlay, nextIconPosX, nextPosY, iconWidth, iconHeight);
						inIconArea = false;
						if inArea then inIconArea = overlay.mouseInArea();end;
						local helpInfo = vmGroupsXml:canSaveBySavegame();
						if inIconArea then 
							g_currentMission.hlUtils.setBackgroundColor(overlay, g_currentMission.hlUtils.getColor(box.overlays.color.inArea, true));
						elseif box.settingTyp == 3 and VehicleManager_Display:getHostOrSp() then
							g_currentMission.hlUtils.setBackgroundColor(overlay, g_currentMission.hlUtils.getColor(box.overlays.color.notActive, true));
						else 
							g_currentMission.hlUtils.setBackgroundColor(overlay, g_currentMission.hlUtils.getColor(box.overlays.color.on, true));
						end;
						overlay:render();						
										
						local infoTxt = "";
						if not helpInfo then infoTxt = "\n".. g_i18n:getText("groups_notGenerate");end;
						if inIconArea then setInfoHelpText(g_i18n:getText("groups_generate").. infoTxt, 0);end;					
						if not g_currentMission.hlUtils:disableInArea() and inArea and inIconArea then box:setClickArea( {overlay.x, overlay.x+overlay.width, overlay.y, overlay.y+overlay.height, onClick=VehicleManager_Display_MouseKeyEventsBox.onClickArea, whatClick="VehicleManager_Display_Box", typPos=boxNumber, whereClick="settingGenerateGroups_", ownTable={}} );end;
						
						nextIconPosX = nextIconPosX+iconWidth+difW;					
					end;									
				else
					setWarningLine = true;
				end;				
			end;
			
			if box.settingTyp == 3 then				
				if not setWarningLine and nextIconPosX+iconWidth < x+w then					
					overlay = overlayDefaultGroup[overlayDefaultByName["copyPaste"]];
					if overlay ~= nil then
						g_currentMission.hlUtils.setOverlay(overlay, nextIconPosX, nextPosY, iconWidth, iconHeight);
						inIconArea = false;
						if inArea then inIconArea = overlay.mouseInArea();end;
						if inIconArea then 
							g_currentMission.hlUtils.setBackgroundColor(overlay, g_currentMission.hlUtils.getColor(box.overlays.color.inArea, true));
						elseif vmGroups.values.hasVorlage then 
							g_currentMission.hlUtils.setBackgroundColor(overlay, g_currentMission.hlUtils.getColor(box.overlays.color.on, true));
						else 
							g_currentMission.hlUtils.setBackgroundColor(overlay, g_currentMission.hlUtils.getColor(box.overlays.color.notActive, true));
						end;
						overlay:render();						
						local infoTxt = "";
						if not vmGroups.values.hasVorlage then infoTxt = g_i18n:getText("profile_vorlage_notFound");else infoTxt = string.format(g_i18n:getText("profile_vorlage_copyPaste"), g_i18n:getText("profile_vorlage")).. "\n../modSettings/HL/FS25_VehicleManagerDisplay/\nvm_Vorlage_Profil.xml";end;
						if inIconArea then setInfoHelpText(infoTxt, 0);end;
						if vmGroups.values.hasVorlage and not g_currentMission.hlUtils:disableInArea() and inArea and inIconArea then box:setClickArea( {overlay.x, overlay.x+overlay.width, overlay.y, overlay.y+overlay.height, onClick=VehicleManager_Display_MouseKeyEventsBox.onClickArea, whatClick="VehicleManager_Display_Box", typPos=boxNumber, whereClick="settingCopyPasteVorlage_", ownTable={}} );end;
						nextIconPosX = nextIconPosX+iconWidth+difW;
					end;					
				else
					setWarningLine = true;	
				end;				
				if not setWarningLine and nextIconPosX+iconWidth < x+w then					
					overlay = overlayDefaultGroup[overlayDefaultByName["folderVorlage"]];
					if overlay ~= nil then
						g_currentMission.hlUtils.setOverlay(overlay, nextIconPosX, nextPosY, iconWidth, iconHeight);
						inIconArea = false;
						if inArea then inIconArea = overlay.mouseInArea();end;
						if inIconArea then 
							g_currentMission.hlUtils.setBackgroundColor(overlay, g_currentMission.hlUtils.getColor(box.overlays.color.inArea, true));
						elseif vmGroups.values.hasVorlage then 
							g_currentMission.hlUtils.setBackgroundColor(overlay, g_currentMission.hlUtils.getColor(box.overlays.color.text, true));
						else 
							g_currentMission.hlUtils.setBackgroundColor(overlay, g_currentMission.hlUtils.getColor(box.overlays.color.notActive, true));
						end;
						overlay:render();						
						local infoTxt = "";
						if not vmGroups.values.hasVorlage then infoTxt = g_i18n:getText("profile_vorlage_notFound").. "\n".. g_i18n:getText("profile_vorlage_generate");else infoTxt = g_i18n:getText("profile_vorlage_generate");end;
						if inIconArea then setInfoHelpText(infoTxt, 0);end;
						if not g_currentMission.hlUtils:disableInArea() and inArea and inIconArea then box:setClickArea( {overlay.x, overlay.x+overlay.width, overlay.y, overlay.y+overlay.height, onClick=VehicleManager_Display_MouseKeyEventsBox.onClickArea, whatClick="VehicleManager_Display_Box", typPos=boxNumber, whereClick="settingGenerateVorlage_", ownTable={}} );end;
						nextIconPosX = nextIconPosX+iconWidth+difW;
					end;					
				else
					setWarningLine = true;	
				end;
			end;
			
			if setWarningLine then
				setWarningLineIcon();
			end;			
			nextPosY = nextPosY-box.ownTable.lineHeight;
		end;
		--viewExtraLineSetting--
		--viewExtraLine--
		function viewExtraLine()
			if nextPosY < y then return;end;			
			local onOffTxt = g_i18n:getText("ui_on").. "/".. g_i18n:getText("ui_off");
			local setWarningLine = false;
			local inIconArea = false;
			function setOverlay(whereClick, ownTable, color, blinking, setPosX, otherX, otherWidth, otherHeight)
				if color == nil then color = box.overlays.color.notActive;end;
				g_currentMission.hlUtils.setOverlay(overlay, otherX or nextIconPosX, nextPosY, otherWidth or iconWidth, otherHeight or iconHeight);
				inIconArea = false;
				if inArea then inIconArea = overlay.mouseInArea();end;
				g_currentMission.hlUtils.setBackgroundColor(overlay, g_currentMission.hlUtils.getColor(color, true));
				local dropIcon = false;
				if blinking ~= nil then
					if blinking and g_currentMission.hlUtils.runsTimer("1sec", true) then
						dropIcon = true;
					end;
				else
					dropIcon = true;
				end;
				if dropIcon then overlay:render();end;
				if not g_currentMission.hlUtils:disableInArea() and inArea and inIconArea and whereClick ~= nil then box:setClickArea( {overlay.x, overlay.x+overlay.width, overlay.y, overlay.y+overlay.height, onClick=VehicleManager_Display_MouseKeyEventsBox.onClickArea, whatClick="VehicleManager_Display_Box", typPos=boxNumber, whereClick=whereClick, ownTable=ownTable or {}} );end;
				if setPosX == nil or setPosX then 
					if otherX ~= nil then 
						nextIconPosX = otherX+(otherWidth or iconWidth)+difW;
					else
						nextIconPosX = nextIconPosX+(otherWidth or iconWidth)+difW;
					end;
				end;
				iconColor = nil;				
			end;						
			if not setWarningLine and nextIconPosX+iconWidth < x+w then
				overlay = overlayDefaultGroup[overlayDefaultByName["driverActive"]];
				if overlay ~= nil then
					if box.ownTable.view.driverActiveIcon[1] > 1 then iconColor = box.overlays.color.on;end;					
					setOverlay("view_", {"driverActiveIcon"}, iconColor);					
					if box.isHelp and inIconArea then setInfoHelpText(g_i18n:getText("box_viewDriverActiveIcon"), 0);end;
				end;					
			else
				setWarningLine = true;
			end;
			--if VehicleManager_Display.autoDrive.loaded then
			--	if not setWarningLine and nextIconPosX+iconWidth < x+w then
			--		overlay = overlayDefaultGroup[overlayDefaultByName["adIcon"]];
			--		if overlay ~= nil then
			--			if box.ownTable.view.adHudIcon[1] > 1 then iconColor = box.overlays.color.text;end;					
			--			setOverlay("view_", {"adHudIcon"}, iconColor);					
			--			if box.isHelp and inIconArea then setInfoHelpText(g_i18n:getText("adHud_viewAdHudIcon"), 0);end;
			--		end;					
			--	else
			--		setWarningLine = true;
			--	end;
			--end;
			if not setWarningLine and nextIconPosX+iconWidth < x+w then
				overlay = overlayDefaultGroup[overlayDefaultByName["closeLines"]];
				if overlay ~= nil then
					if isOpenGroup ~= nil and isOpenGroup then iconColor = box.overlays.color.warning;end;
					if (isOpenGroup ~= nil and not isOpenGroup) then
						setOverlay(nil, nil, iconColor);
					else
						setOverlay("closeAllDetailsLines_", nil, iconColor);
					end;
					if box.isHelp and inIconArea then setInfoHelpText(g_i18n:getText("box_closeDetailsLines"));end;
				end;					
			else
				setWarningLine = true;
			end;						
			if box.isHelp then
				if not setWarningLine and nextIconPosX+iconWidth < x+w then
					overlay = overlayDefaultGroup[overlayDefaultByName["infos"]];
					if overlay ~= nil then					
						setOverlay(nil, nil, box.overlays.color.title); 				
						if inIconArea then setInfoHelpText(string.format(g_i18n:getText("box_clickInfos"), vmGroups:getActiveProfil().. ".xml"), 0);end;
					end;					
				else
					setWarningLine = true;
				end;
			end;
			--set icon right--
			if not setWarningLine and nextIconPosX+(iconWidth*2) < x+w then
				overlay = overlayDefaultGroup[overlayDefaultByName["insertRemove"]];
				if overlay ~= nil then					
					if box.ownTable.modus[1] > 1 then						
						iconColor = box.overlays.color.columTitle; 
						setOverlay("modus_", {}, iconColor, true, nil, nextRightPosX-(iconWidth*2), iconWidth*2);
					else
						setOverlay("modus_", {}, iconColor, nil, nil, nextRightPosX-(iconWidth*2), iconWidth*2);						
					end;
					if inIconArea then setInfoHelpText(g_i18n:getText("box_modus".. tostring(box.ownTable.modus[1])), 0);end;
				end;
			else
				setWarningLine = true;
			end;
			--set icon right--
			if setWarningLine then
				setWarningLineIcon();
			end;
			nextPosY = nextPosY-box.ownTable.lineHeight;
		end;		
		if box.viewExtraLine and not box.isSetting then viewExtraLine();elseif box.viewExtraLine and box.isSetting then viewExtraLineSetting();end;
		--viewExtraLine--
		--box lines--		
		local color = nil;		
		local viewDetailsColor = g_currentMission.hlUtils.getColor(box.overlays.color.columText1, true);
		local bounds1 = box.screen.bounds[1];
		local bounds2 = box.screen.bounds[2];
		local extraLineBounds = 0;
		for t=bounds1, bounds2 do			
			overlay = nil;
			typesOverlay = nil;				
			local text = "";
			if nextPosY < y then break;end;
			
			local canNextView = true;
			local lineWidth = w-(difW*2);
			
			function getInIconArea(posX, posY, width, height)
				if not inArea then return false;end;
				overlay = box.overlays.bgLine; --hidden overlay
				if overlay ~= nil then
					g_currentMission.hlUtils.setOverlay(overlay, posX, posY or nextPosY, width or lineWidth, height or box.ownTable.lineHeight);
					return overlay.mouseInArea();
				end;
				return false;
			end;
			
			local isNextPosY = false;
			function setNextPosY()
				if isNextPosY then
					nextPosY = nextPosY-box.ownTable.lineHeight;							
					lineWidth = w-(difW*2);
					nextLeftPosX = x+difW;				
					nextRightPosX = x+w-difW;
					canNextView = true;
					isNextPosY = false;
				end;
			end;
			
			if not profileSetting then				
				if VehicleManager_Display.viewGroupsBox[t] ~= nil then
					local line = VehicleManager_Display.viewGroupsBox[t];
					color = g_currentMission.hlUtils.getColor(box.overlays.color.text, true);
					local lineTypName = tostring(line.name);
					
					
					if canNextView then
						if nextPosY > y then
							local missionsGroup = line.isGroup and line.isMission ~= nil;
							local dropViViewIcon = false;							
							local inSettingIconArea = false;
							local inViViewIconArea = false;
							if box.isSetting then
								if box.settingTyp == 2 and (line.isGroup or line.isUgroup) then
									if line.isUgroup then 
										overlay = overlayDefaultGroup[overlayDefaultByName["folderLine"]];
										if vmGroups.values.groups[line.group].uGroups[line.uGroup+1] == nil then
											overlay = overlayDefaultGroup[overlayDefaultByName["folderLineEnd"]];
										end;
										if overlay ~= nil then
											nextLeftPosX = nextLeftPosX+iconWidth/2;
											g_currentMission.hlUtils.setOverlay(overlay, nextLeftPosX, nextPosY, iconWidth, iconHeight);
											g_currentMission.hlUtils.setBackgroundColor(overlay, g_currentMission.hlUtils.getColor(box.overlays.color.columText1, true));
											overlay:render();											
										end;
										lineWidth = lineWidth-iconWidth;
										nextLeftPosX = nextLeftPosX+iconWidth;
										canNextView = lineWidth > iconWidth;
										isNextPosY = true;
									end;
									if canNextView then
										overlay = overlayDefaultGroup[overlayDefaultByName["edit"]];
										if overlay ~= nil then
											g_currentMission.hlUtils.setOverlay(overlay,nextLeftPosX, nextPosY, iconWidthS, iconHeightS);
											local inIconArea = false;
											if inArea then inIconArea = overlay.mouseInArea();end;
											if inIconArea then 
												g_currentMission.hlUtils.setBackgroundColor(overlay, g_currentMission.hlUtils.getColor(box.overlays.color.inArea, true));
												if box.isHelp then setInfoHelpText(string.format(g_i18n:getText("groups_rename"), lineTypName));end;
											else
												if line.isUgroup then
													g_currentMission.hlUtils.setBackgroundColor(overlay, g_currentMission.hlUtils.getColor(box.overlays.color.on, true, nil, 0.80));
												else
													g_currentMission.hlUtils.setBackgroundColor(overlay, g_currentMission.hlUtils.getColor(box.overlays.color.on, true));
												end;
											end;
											if not missionsGroup then
												overlay:render();
												if not g_currentMission.hlUtils:disableInArea() and inArea and inIconArea then box:setClickArea( {overlay.x, overlay.x+overlay.width, overlay.y, overlay.y+overlay.height, onClick=VehicleManager_Display_MouseKeyEventsBox.onClickArea, whatClick="VehicleManager_Display_Box", typPos=boxNumber, whereClick="settingRenameGroups_", ownTable={name=lineTypName,group=line.group,uGroup=line.uGroup}} );end;
											end;
											lineWidth = lineWidth-iconWidth;
											nextLeftPosX = nextLeftPosX+iconWidth;
											canNextView = lineWidth > iconWidth;
											isNextPosY = true;										
										end;
									end;
									if canNextView then
										overlay = overlayDefaultGroup[overlayDefaultByName["delete"]];
										if overlay ~= nil then																				
											g_currentMission.hlUtils.setOverlay(overlay, nextRightPosX-iconWidth, nextPosY, iconWidthS, iconHeightS);
											local inIconArea = false;
											if inArea then inIconArea = overlay.mouseInArea();end;
											if inIconArea then 
												inSettingIconArea = true;
												g_currentMission.hlUtils.setBackgroundColor(overlay, g_currentMission.hlUtils.getColor(box.overlays.color.inArea, true));
												local moreTxt = "";
												if line.isGroup and #vmGroups.values.groups[line.group].uGroups > 0 then moreTxt = "\n".. g_i18n:getText("groups_delete2");end;
												if box.isHelp then setInfoHelpText(string.format(g_i18n:getText("groups_delete"), lineTypName).. moreTxt, 0);end;
											else
												g_currentMission.hlUtils.setBackgroundColor(overlay, g_currentMission.hlUtils.getColor(box.overlays.color.warning, true));
											end;
											overlay:render();
											if not g_currentMission.hlUtils:disableInArea() and inArea and inIconArea then box:setClickArea( {overlay.x, overlay.x+overlay.width, overlay.y, overlay.y+overlay.height, onClick=VehicleManager_Display_MouseKeyEventsBox.onClickArea, whatClick="VehicleManager_Display_Box", typPos=boxNumber, whereClick="settingDeleteGroups_", ownTable={name=lineTypName,group=line.group,uGroup=line.uGroup}} );end;
											lineWidth = lineWidth-iconWidth;
											nextRightPosX = nextRightPosX-iconWidth;
											canNextView = lineWidth > iconWidth;
											isNextPosY = true;										
										end;									
									end;
									if canNextView then
										if line.isUgroup and #vmGroups.values.groups > 1 and (line.uGroup == 1 or line.uGroup == #vmGroups.values.groups[line.group].uGroups) then
											local setBeforeGroup = line.uGroup == 1;
											local setAfterGroup = not setBeforeGroup;
											local setBeforeOrAfterGroup = #vmGroups.values.groups[line.group].uGroups == 1;
											if setBeforeOrAfterGroup then overlay = overlayDefaultGroup[overlayDefaultByName["lineHorizontalUpDown"]];elseif setBeforeGroup then overlay = overlayDefaultGroup[overlayDefaultByName["lineHorizontalUp"]];else overlay = overlayDefaultGroup[overlayDefaultByName["lineHorizontalDown"]];end;
											if overlay ~= nil then
												g_currentMission.hlUtils.setOverlay(overlay, nextRightPosX-iconWidth, nextPosY, iconWidthS, iconHeightS);
												local inIconArea = false;
												if inArea then inIconArea = overlay.mouseInArea();end;
												if inIconArea then 
													inSettingIconArea = true;
													g_currentMission.hlUtils.setBackgroundColor(overlay, g_currentMission.hlUtils.getColor(box.overlays.color.inArea, true));
													if box.isHelp then 
														if setBeforeOrAfterGroup then setInfoHelpText(string.format(g_i18n:getText("groups_moveBeforeOrAfterGroup"), lineTypName), 0);elseif setBeforeGroup then setInfoHelpText(string.format(g_i18n:getText("groups_moveBeforeGroup"), lineTypName), 0);else setInfoHelpText(string.format(g_i18n:getText("groups_moveAfterGroup"), lineTypName), 0);end;
													end;
												else
													g_currentMission.hlUtils.setBackgroundColor(overlay, g_currentMission.hlUtils.getColor(box.overlays.color.text, true));
												end;
												overlay:render();
												if not g_currentMission.hlUtils:disableInArea() and inArea and inIconArea then box:setClickArea( {overlay.x, overlay.x+overlay.width, overlay.y, overlay.y+overlay.height, onClick=VehicleManager_Display_MouseKeyEventsBox.onClickArea, whatClick="VehicleManager_Display_Box", typPos=boxNumber, whereClick="settingNewPositionNextGroup_", ownTable={name=lineTypName,group=line.group,uGroup=line.uGroup}} );end;
											end;										
										end;										
										lineWidth = lineWidth-iconWidth;
										nextRightPosX = nextRightPosX-iconWidth;
										canNextView = lineWidth > iconWidth;
										isNextPosY = true;
										
									end;
									if canNextView and ( (line.isGroup and #vmGroups.values.groups > 1) or (line.isUgroup and #vmGroups.values.groups[line.group].uGroups > 1) ) then
										overlay = overlayDefaultGroup[overlayDefaultByName["lineHorizontalUpDown"]];
										if overlay ~= nil then
											g_currentMission.hlUtils.setOverlay(overlay, nextRightPosX-iconWidth, nextPosY, iconWidthS, iconHeightS);
											local inIconArea = false;
											if inArea then inIconArea = overlay.mouseInArea();end;
											if inIconArea then 
												inSettingIconArea = true;
												g_currentMission.hlUtils.setBackgroundColor(overlay, g_currentMission.hlUtils.getColor(box.overlays.color.inArea, true));
												if box.isHelp then 
													if line.isGroup then setInfoHelpText(string.format(g_i18n:getText("groups_newPositionGroup"), lineTypName));else setInfoHelpText(string.format(g_i18n:getText("groups_newPositionUgroup"), lineTypName));end;
												end;
											else
												g_currentMission.hlUtils.setBackgroundColor(overlay, g_currentMission.hlUtils.getColor(box.overlays.color.text, true));
											end;
											overlay:render();
											if not g_currentMission.hlUtils:disableInArea() and inArea and inIconArea then box:setClickArea( {overlay.x, overlay.x+overlay.width, overlay.y, overlay.y+overlay.height, onClick=VehicleManager_Display_MouseKeyEventsBox.onClickArea, whatClick="VehicleManager_Display_Box", typPos=boxNumber, whereClick="settingNewPositionGroups_", ownTable={name=lineTypName,group=line.group,uGroup=line.uGroup}} );end;
											lineWidth = lineWidth-iconWidth;
											nextRightPosX = nextRightPosX-iconWidth;
											canNextView = lineWidth > iconWidth;
											isNextPosY = true;
										end;
									end;
								end;
							elseif VehicleManager_Display.vehicleInspector and (line.isGroup or line.isUgroup) and line.typIdLength > 0 then
								local viewViIcon = true;
								if g_currentMission.hlHudSystem.ownData.hiddenMods ~= nil and g_currentMission.hlHudSystem.ownData.hiddenMods["VehicleInspector"] ~= nil and g_currentMission.hlHudSystem.ownData.hiddenMods["VehicleInspector"].isHidden then viewViIcon = false;end;
								overlay = overlayDefaultGroup[overlayDefaultByName["view"]];								
								if overlay ~= nil and viewViIcon then
									local uGroupViewTyp = false;
									if line.isGroup and not line.viewOpen and #vmGroups.values.groups[line.group].uGroups > 0 then uGroupViewTyp = vmGroups:isUgroupViewTyp(line.group);end;
									g_currentMission.hlUtils.setOverlay(overlay, nextRightPosX-iconWidth, nextPosY, iconWidth, iconHeight);
									local inIconArea = false;
									if inArea then inIconArea = overlay.mouseInArea();end;
									if inIconArea then 
										inViViewIconArea = true;
										--g_currentMission.hlUtils.setBackgroundColor(overlay, g_currentMission.hlUtils.getColor(box.overlays.color.inArea, true));
										if box.isHelp then 
											if uGroupViewTyp and not line.viewOpen and line.isGroup then
												setInfoHelpText(g_i18n:getText("groups_viewTyp").. "\n".. g_i18n:getText("groupsU_viewTyp"), 0);
											else
												setInfoHelpText(g_i18n:getText("groups_viewTyp"));
											end;
										end;
									end;
									if line.viewTyp > 1 then
										g_currentMission.hlUtils.setBackgroundColor(overlay, g_currentMission.hlUtils.getColor(box.overlays.color.on, true));
									elseif uGroupViewTyp and not line.viewOpen and line.isGroup then
										g_currentMission.hlUtils.setBackgroundColor(overlay, g_currentMission.hlUtils.getColor("yellow2", true));
									else
										g_currentMission.hlUtils.setBackgroundColor(overlay, g_currentMission.hlUtils.getColor(box.overlays.color.notActive, true));
									end;									
									overlay:render();
									if not g_currentMission.hlUtils:disableInArea() and inArea and inIconArea then box:setClickArea( {overlay.x, overlay.x+overlay.width, overlay.y, overlay.y+overlay.height, onClick=VehicleManager_Display_MouseKeyEventsBox.onClickArea, whatClick="VehicleManager_Display_Box", typPos=boxNumber, whereClick="viewTypGroups_", ownTable={name=lineTypName,group=line.group,uGroup=line.uGroup}} );end;
									lineWidth = lineWidth-iconWidth;
									nextRightPosX = nextRightPosX-iconWidth-difW;
									canNextView = lineWidth > iconWidth;
									isNextPosY = true;
									dropViViewIcon = true;
								end;								
							end;						
							if canNextView then
								if line.isGroup or line.isUgroup then
									local dropAdStartGroupIcon = false;									
									--viewStartGroupIcon--
									if VehicleManager_Display.autoDrive.loaded and VehicleManager_Display.autoDrive.startGroup.isReady and not box.isSetting and line.typIdLength > 0 then
										overlay = overlayDefaultGroup[overlayDefaultByName["adIconGroup"]];
										if overlay ~= nil then
											g_currentMission.hlUtils.setOverlay(overlay, nextRightPosX-(iconWidth), nextPosY, iconWidth, iconHeight);
											if VehicleManager_Display.autoDrive.startGroup.isActive() then
												g_currentMission.hlUtils.setBackgroundColor(overlay, g_currentMission.hlUtils.getColor(box.overlays.color.off, true));
											elseif #VehicleManager_Display.autoDrive.startGroup.copyPasteCourse > 0 then
												g_currentMission.hlUtils.setBackgroundColor(overlay, g_currentMission.hlUtils.getColor(box.overlays.color.on, true));
											else
												g_currentMission.hlUtils.setBackgroundColor(overlay, g_currentMission.hlUtils.getColor(box.overlays.color.text, true));
											end;
											local inIconArea = false;
											if inArea then inIconArea = overlay.mouseInArea();end;
											if box.isHelp and inIconArea then 													
												local helpText = g_i18n:getText("adHud_box_adStartGroupIcon");
												if #VehicleManager_Display.autoDrive.startGroup.copyPasteCourse > 0 then
													local mapMarker = FS25_AutoDrive.ADGraphManager:getMapMarkerById(VehicleManager_Display.autoDrive.startGroup.copyPasteCourse[1]);
													helpText = helpText.. "\n".. tostring(string.format(g_i18n:getText("adHud_course_atCache"), tostring(mapMarker.name)));
												else
													helpText = helpText.. "\n".. tostring(string.format(g_i18n:getText("adHud_course_atCache"), tostring(g_i18n:getText("ui_no"))));
												end;												
												setInfoHelpText(helpText, 0);													
											end;
											overlay:render();
											if not g_currentMission.hlUtils:disableInArea() and inArea and inIconArea then box:setClickArea( {overlay.x, overlay.x+overlay.width, overlay.y, overlay.y+overlay.height, onClick=VehicleManager_Display_MouseKeyEventsBox.onClickArea, whatClick="VehicleManager_Display_Box", typPos=boxNumber, whereClick="startGroupIcon_", ownTable={name=lineTypName,group=line.group,uGroup=line.uGroup}} );end;
											lineWidth = lineWidth-iconWidth;
											nextRightPosX = nextRightPosX-iconWidth-difW;
											canNextView = lineWidth > iconWidth;
											isNextPosY = true;
											dropAdStartGroupIcon = true;
										end;
									end;
									--viewStartGroupIcon--
									--viewDriverActiveIcon--
									local dropDriverActiveIcon = false;
									if canNextView and not box.isSetting and box.ownTable.view.driverActiveIcon[1] > 1 and not line.viewOpen and line.typIdLength > 0 then
										local tempIconWidth = iconWidth;
										if dropViViewIcon or dropAdStartGroupIcon then tempIconWidth = iconWidth*1.5;end;
										if lineWidth > tempIconWidth then
											if line.isHelper or line.isPlayer or line.isOtherPlayer then
												overlay = overlayDefaultGroup[overlayDefaultByName["driverActive"]];
												if overlay ~= nil then
													g_currentMission.hlUtils.setOverlay(overlay, nextRightPosX-(tempIconWidth), nextPosY, iconWidth, iconHeight);
													if line.isPlayer and not line.isOtherPlayer then
														g_currentMission.hlUtils.setBackgroundColor(overlay, g_currentMission.hlUtils.getColor(box.ownTable.showColors.playerControlled, true));
													elseif (line.isPlayer and line.isOtherPlayer) or line.isOtherPlayer then
														g_currentMission.hlUtils.setBackgroundColor(overlay, g_currentMission.hlUtils.getColor(box.ownTable.showColors.otherControlled, true));
													elseif line.isHelper then
														g_currentMission.hlUtils.setBackgroundColor(overlay, g_currentMission.hlUtils.getColor(box.ownTable.showColors.helperControlled, true));
													else --unknown
														g_currentMission.hlUtils.setBackgroundColor(overlay, g_currentMission.hlUtils.getColor(box.ownTable.showColors.unknownControlled, true));
													end;
													overlay:render();
													lineWidth = lineWidth-(tempIconWidth);
													nextRightPosX = nextRightPosX-(tempIconWidth);													
													canNextView = lineWidth > iconWidth;
													isNextPosY = true;
													dropDriverActiveIcon = true;
												end;
											end;
										end;
									end;
									--viewDriverActiveIcon--									
									if canNextView then
										local moreTxt = "";
										local uGroupsTypIdLength = "";									
										local uGroupMarkerText = "";										
										if not box.isSetting or box.settingTyp == 1 then
											if not box.isSetting then
												if line.isGroup and not line.viewOpen and line.typIdLengthUgroups > 0 then uGroupsTypIdLength = tostring(line.typIdLengthUgroups);end;
												if line.isGroup and not line.viewOpen then  
													if uGroupsTypIdLength:len() > 0 then
														moreTxt = tostring(uGroupsTypIdLength);
														if line.typIdLength == 0 then moreTxt = " (_".. uGroupSeparator.. tostring(uGroupsTypIdLength).. ")";else moreTxt = " (".. tostring(line.typIdLength).. uGroupSeparator.. tostring(uGroupsTypIdLength).. ")";end;
													else											
														if line.typIdLength > 0 then moreTxt = " (".. tostring(line.typIdLength).. ")";end;
													end;
												elseif line.isUgroup and not line.viewOpen and line.typIdLength > 0 then
													moreTxt = " (".. tostring(line.typIdLength).. ")";
												end;
											end;
											--view folders--											
											local inIconFolderArea = false;
											local folderIconColor = box.overlays.color.notActive;
											local folderIconWidth = iconWidth;
											if line.isGroup then
												if line.viewOpen then
													overlay = overlayDefaultGroup[overlayDefaultByName["folderOpen"]];
												else
													overlay = overlayDefaultGroup[overlayDefaultByName["folder"]];
												end;												
												if line.typIdLength > 0 or line.hasUgroups then folderIconColor = box.overlays.color.columText1;end;												
											else
												if line.viewOpen then
													overlay = overlayDefaultGroup[overlayDefaultByName["folderOpenWithLine"]];
												else
													overlay = overlayDefaultGroup[overlayDefaultByName["folderWithLine"]];
												end;
												if line.typIdLength > 0 then folderIconColor = box.overlays.color.columText1;end;
												folderIconWidth = iconWidth*2
											end;
											g_currentMission.hlUtils.setOverlay(overlay, nextLeftPosX, nextPosY, folderIconWidth, iconHeight);
											if inArea then inFolderIconArea = overlay.mouseInArea();end;
											--Controlled Vehicle at Group, Info Icon--
											if box.ownTable.view.vehicleAtGroupsIcon[1] > 1 and vmGroups:getControlledVehicleGroup(line.group, line.uGroup) then 
												folderIconColor = box.overlays.color.title;
												if box.isHelp and inFolderIconArea then 
													setInfoHelpText(g_i18n:getText("groups_vehicleAtGroup"));
												end;
											end;
											--Controlled Vehicle at Group, Info Icon--
											g_currentMission.hlUtils.setBackgroundColor(overlay, g_currentMission.hlUtils.getColor(folderIconColor, true));
											overlay:render();												
											if inFolderIconArea and not g_currentMission.hlUtils:disableInArea() and inArea then box:setClickArea( {overlay.x, overlay.x+overlay.width, overlay.y, overlay.y+overlay.height, onClick=VehicleManager_Display_MouseKeyEventsBox.onClickArea, whatClick="VehicleManager_Display_Box", typPos=boxNumber, whereClick="groupsFolder_", ownTable={name=lineTypName,group=line.group,uGroup=line.uGroup}} );end;
											--if inFolderIconArea then overlay:render();end;											
											lineWidth = lineWidth-folderIconWidth;
											nextLeftPosX = nextLeftPosX+folderIconWidth+(difW/2);											
											canNextView = lineWidth > iconWidth;
											isNextPosY = true;											
											--view folders--											
										end;										
										text = g_currentMission.hlUtils.getTxtToWidth(uGroupMarkerText.. lineTypName.. moreTxt, size, lineWidth, false, ".", true);
										local textWidth = g_currentMission.hlUtils.getTextWidth(text, size, true);							
										--
										local settingWidthGenerateIcon = 0;
										if box.isSetting and box.settingTyp == 2 and line.isGroup and not line.isUgroup and not missionsGroup and lineWidth > iconWidth+textWidth+difW then settingWidthGenerateIcon = iconWidth;end;
										--
										local inTextArea = false;
										if inSettingIconArea or inViViewIconArea or inFolderIconArea or getInIconArea(nextLeftPosX, nil, textWidth+settingWidthGenerateIcon, nil) then
											--color = box.overlays.color.text;
											inTextArea = true;
											setTextBold(true);										
										end;											
										if (line.isGroup and (line.typIdLength > 0 or line.hasUgroups)) or (line.isUgroup and line.typIdLength > 0) or (box.isSetting and not box.settingTyp == 2) then
											--color = box.overlays.color.text;
																					
											setTextColor(unpack(g_currentMission.hlUtils.getColor(box.overlays.color.columText1, true, nil, 0.95)));
										else
											color = box.overlays.color.notActive;
											setTextColor(unpack(g_currentMission.hlUtils.getColor(color, true)));
										end;											
																					
										renderText(nextLeftPosX, nextPosY, size, tostring(text));					
										--if inTextArea then renderText(nextLeftPosX, nextPosY, size, tostring(text));end;
										setTextColor(1, 1, 1, 1);							
										setTextBold(false);										
										if not g_currentMission.hlUtils:disableInArea() and inArea then box:setClickArea( {nextLeftPosX, nextLeftPosX+textWidth, nextPosY, nextPosY+box.ownTable.lineHeight, onClick=VehicleManager_Display_MouseKeyEventsBox.onClickArea, whatClick="VehicleManager_Display_Box", typPos=boxNumber, whereClick="groupsName_", ownTable={name=lineTypName,group=line.group,uGroup=line.uGroup}} );end;
										lineWidth = lineWidth-textWidth-difW;
										canNextView = lineWidth > iconWidth;								
										nextLeftPosX = nextLeftPosX+textWidth+difW;
										isNextPosY = true;
										if canNextView then
											if box.isSetting and box.settingTyp == 2 and line.isGroup and not line.isUgroup and not missionsGroup then
												--Under Groups generate Icon--
												overlay = overlayDefaultGroup[overlayDefaultByName["generate"]];
												if overlay ~= nil then					
													g_currentMission.hlUtils.setOverlay(overlay, nextLeftPosX, nextPosY, iconWidth, iconHeight);													
													local inIconArea = false;
													if inArea then inIconArea = overlay.mouseInArea();end;
													if inIconArea then
														g_currentMission.hlUtils.setBackgroundColor(overlay, g_currentMission.hlUtils.getColor(box.overlays.color.inArea, true));
													else
														g_currentMission.hlUtils.setBackgroundColor(overlay, g_currentMission.hlUtils.getColor(box.overlays.color.text, true));
													end;
													if box.isHelp and inIconArea then 													
														setInfoHelpText(string.format(g_i18n:getText("groupsU_generate"), lineTypName));													
													end;
													overlay:render();
													if not g_currentMission.hlUtils:disableInArea() and inArea and inIconArea then box:setClickArea( {overlay.x, overlay.x+overlay.width, overlay.y, overlay.y+overlay.height, onClick=VehicleManager_Display_MouseKeyEventsBox.onClickArea, whatClick="VehicleManager_Display_Box", typPos=boxNumber, whereClick="settingGenerateGroups_", ownTable={name=lineTypName,group=line.group,uGroup=line.uGroup}} );end;
													lineWidth = lineWidth-iconWidth;
													canNextView = lineWidth > iconWidth;								
													nextLeftPosX = nextLeftPosX+iconWidth;
													isNextPosY = true;
												end;	
												--Under Groups generate Icon--
											end;
										end;
									end;
								elseif not box.isSetting and line.isVehicle then
									local vehicle = g_currentMission.nodeToObject[line.node];									
									if vehicle ~= nil then --and lineTypName ~= "VehicleName Unknown" then
										--vehicle folder line--
										if box.ownTable.view.folderLines[1] > 1 then
											overlay = overlayDefaultGroup[overlayDefaultByName["folderLineEnd"]];
											if line.isGroupVehicle then											
												if line.hasUgroups or (VehicleManager_Display.viewGroupsBox[t+1] ~= nil and VehicleManager_Display.viewGroupsBox[t+1].isVehicle) then
													overlay = overlayDefaultGroup[overlayDefaultByName["folderLine"]];
												end;											
											else
												if VehicleManager_Display.viewGroupsBox[t+1] ~= nil and VehicleManager_Display.viewGroupsBox[t+1].isVehicle then
													overlay = overlayDefaultGroup[overlayDefaultByName["folderLine"]];
												end;
												nextLeftPosX = nextLeftPosX+(iconWidth/2);											
											end;
											if overlay ~= nil then
												g_currentMission.hlUtils.setOverlay(overlay, nextLeftPosX, nextPosY, iconWidth, iconHeight);												
												g_currentMission.hlUtils.setBackgroundColor(overlay, g_currentMission.hlUtils.getColor(box.overlays.color.columText1, true));												
												overlay:render();
												lineWidth = lineWidth-iconWidth;
												nextLeftPosX = nextLeftPosX+iconWidth;
												canNextView = lineWidth > iconWidth;
												isNextPosY = true;
											end;
										end;
										--markedVehicle by VehicleInspector--
										if vehicle.viIsMarked ~= nil and vehicle.viIsMarked then
											overlay = overlayDefaultGroup[overlayDefaultByName["markedVehicle"]];
											if overlay ~= nil then
												g_currentMission.hlUtils.setOverlay(overlay, x-(iconWidth/2.2), nextPosY, iconWidth, iconHeight);															
												overlay:render();
											end;
										end;
										--markedVehicle by VehicleInspector--									
										--vehicle folder line--
										local vehicleName = line.vehicleName; --or storeName !
										local driverName = line.driverName;
										local viewName = "";																				
										--VehicleIcon--
										local errorTypId = false;
										if box.ownTable.view.vehicleIcon[1] > 1 then											
											if box.ownTable.view.vehicleIcon[1] == 2 then --type icon
												if VehicleManager_Display.vehicleInspector then													
													if vehicle.viTypIcon ~= nil then --new VI type Icon ++prio++
														local typIcon = vehicle.viTypIcon;
														local isFrontLoader = vehicle.configurations ~= nil and vehicle.configurations.frontloader ~= nil and vehicle.configurations.frontloader > 1;
														if isFrontLoader then typIcon = "tractor_frontloader";end;
														overlay = overlayDefaultGroup[overlayDefaultByName[typIcon]];
														if overlay == nil then overlay = overlayDefaultGroup[overlayDefaultByName["tractor_other"]];end;
													elseif vehicle.viCategoryName ~= nil then --old VI type by VI Category														
														overlay = g_currentMission.vehicleInspector.categoryOverlays[g_currentMission.vehicleInspector.vehicleTypeCategoryNumber[vehicle.viCategoryName]]; 
														if overlay == nil then overlay = g_currentMission.vehicleInspector.categoryOverlays[5];end;													
													end;
												else
													overlay = overlayDefaultGroup[overlayDefaultByName[vehicle.vmTypIcon]];
													if overlay == nil then overlay = overlayDefaultGroup[overlayDefaultByName["tractor_other"]];end;
												end;
												if overlay ~= nil then
													g_currentMission.hlUtils.setOverlay(overlay, nextLeftPosX, nextPosY-difH, iconWidthB, iconHeightB);
													g_currentMission.hlUtils.setBackgroundColor(overlay, g_currentMission.hlUtils.getColor(box.overlays.color.text, true, nil, 0.85));
													overlay:render();
													lineWidth = lineWidth-iconWidthB-difW;
													nextLeftPosX = nextLeftPosX+iconWidthB+difW;
													canNextView = lineWidth > iconWidth;
													if not box.isSetting and not g_currentMission.hlUtils:disableInArea() and inArea then box:setClickArea( {overlay.x, overlay.x+overlay.width, overlay.y, overlay.y+box.ownTable.lineHeight, onClick=VehicleManager_Display_MouseKeyEventsBox.onClickArea, whatClick="VehicleManager_Display_Box", typPos=boxNumber, whereClick="vehicleIcon_", ownTable={vehicleNode=line.node,typId=line.typId,name=lineTypName,group=line.group,uGroup=line.uGroup}} );end;
													isNextPosY = true;
												end;
											elseif box.ownTable.view.vehicleIcon[1] == 3 then --vehicle icon
												if g_currentMission.hlUtils.overlays["LS_Vehicles"] ~= nil then
													local overlayVehiclesGroup = g_currentMission.hlUtils.overlays["LS_Vehicles"]["vehicles"];
													local overlayVehiclesByName = g_currentMission.hlUtils.overlays.byName["LS_Vehicles"]["vehicles"];
													--local vehicleOverlay = overlayVehiclesGroup[overlayVehiclesByName[vehicleName]];
													local vehicleOverlay = overlayVehiclesGroup[overlayVehiclesByName[line.name]]; --storeName
													if vehicleOverlay == nil then vehicleOverlay = overlayVehiclesGroup[overlayVehiclesByName[lineTypName]];end;
													if vehicle.trainSystem ~= nil then vehicleOverlay = overlayDefaultGroup[overlayDefaultByName["train"]];elseif vehicle.spec_rideable ~= nil then vehicleOverlay = overlayDefaultGroup[overlayDefaultByName["horse"]];end;
													if vehicleOverlay == nil then vehicleOverlay = overlayDefaultGroup[overlayDefaultByName["tractor_other"]];end;
													if vehicleOverlay ~= nil then									
														if vehicle.trainSystem ~= nil or vehicle.spec_rideable ~= nil then
															g_currentMission.hlUtils.setOverlay(vehicleOverlay, nextLeftPosX+difW, nextPosY-(difH*1.5), iconWidthB, iconHeightB);
														else
															g_currentMission.hlUtils.setOverlay(vehicleOverlay, nextLeftPosX, nextPosY-difH, iconWidthV, iconHeightV);
														end;
														vehicleOverlay:render();
														lineWidth = lineWidth-iconWidthV-difW;
														nextLeftPosX = nextLeftPosX+iconWidthV+difW;
														canNextView = lineWidth > iconWidth;
														if not box.isSetting and not g_currentMission.hlUtils:disableInArea() and inArea then box:setClickArea( {vehicleOverlay.x, vehicleOverlay.x+vehicleOverlay.width, vehicleOverlay.y, vehicleOverlay.y+box.ownTable.lineHeight, onClick=VehicleManager_Display_MouseKeyEventsBox.onClickArea, whatClick="VehicleManager_Display_Box", typPos=boxNumber, whereClick="vehicleIcon_", ownTable={vehicleNode=line.node,typId=line.typId,name=lineTypName,group=line.group,uGroup=line.uGroup}} );end;
														isNextPosY = true;
													else
														vehicleName = "Ghost Vehicle TypId";
														errorTypId = true;												
													end;
												end;
											end;										
										end;
										--VehicleIcon--
										--VehilceName--
										if canNextView then
											local moreTxt = "";											
											--search later optional check over !--
											local isVehicleSave = VehicleManager_DisplaySetGet:isSaved(vehicle); --patch 1.7.0x error --> vehicle.loadCallbackFunction.savegameData ~= nil;											
											
											if g_client ~= nil and g_server == nil then 
												isVehicleSave = true; --unknown is save MP
												--g_currentMission.gameStatsTime = g_currentMission.time + g_currentMission.gameStatsInterval --?
											end;
											--search later optional check over !--
											if not isVehicleSave then moreTxt = " !";end;
											----------
											if not errorTypId and vehicleName ~= nil and driverName ~= nil and box.ownTable.view.combiVehicleName[1] > 1 and box.ownTable.view.vehicleName[1] ~= 5 then
												local combiSeparator = tostring(box.ownTable.viewText.combiVehicleNameSeparator);
												if box.ownTable.view.combiVehicleName[1] == 2 then 
													viewName = vehicleName.. combiSeparator.. driverName;													
												elseif box.ownTable.view.combiVehicleName[1] == 3 then 
													viewName = driverName.. combiSeparator.. vehicleName;	
												end;
											else
												viewName = vehicleName;
											end;
											if viewName == nil or viewName:len() == 0 then viewName = "? - ?";end;
											----------
											if box.ownTable.view.vehicleIcon[1] == 1 then viewName = "*".. viewName;end;
											text = g_currentMission.hlUtils.getTxtToWidth(viewName.. moreTxt, size, lineWidth, false, ".");
											if line.isPlayer then
												setTextColor(unpack(g_currentMission.hlUtils.getColor(box.ownTable.showColors.playerControlled, true)));
											elseif line.isOtherPlayer then
												setTextColor(unpack(g_currentMission.hlUtils.getColor(box.ownTable.showColors.otherControlled, true)));
											elseif line.isHelper then
												setTextColor(unpack(g_currentMission.hlUtils.getColor(box.ownTable.showColors.helperControlled, true)));
											else
												setTextColor(unpack(g_currentMission.hlUtils.getColor(box.overlays.color.text, true, nil, 0.85)));												
											end;
											if not isVehicleSave and getInIconArea(nextLeftPosX) then setInfoHelpText(g_i18n:getText("groups_insertVehicleNotSavegame"), 0, "yellow");end;
											renderText(nextLeftPosX, nextPosY, size, tostring(text));					
											setTextColor(1, 1, 1, 1);
											local textWidth = getTextWidth(size, utf8Substr(text, 0));
											if not box.isSetting and not g_currentMission.hlUtils:disableInArea() and inArea then box:setClickArea( {nextLeftPosX, nextLeftPosX+textWidth, nextPosY, nextPosY+box.ownTable.lineHeight, onClick=VehicleManager_Display_MouseKeyEventsBox.onClickArea, whatClick="VehicleManager_Display_Box", typPos=boxNumber, whereClick="vehicleName_", ownTable={vehicleName=vehicleName,vehicleNode=line.node,typId=line.typId,name=lineTypName,group=line.group,uGroup=line.uGroup}} );end;
											lineWidth = lineWidth-textWidth-difW;
											nextLeftPosX = nextLeftPosX+textWidth+difW;
											canNextView = lineWidth > iconWidth;
											--MP contractor info icon--
											if canNextView and not line.isFarmVehicle then
												overlay = overlayDefaultGroup[overlayDefaultByName["contractor"]];
												if overlay ~= nil then
													g_currentMission.hlUtils.setOverlay(overlay, nextLeftPosX+difW, nextPosY, iconWidthS, iconHeightS);													
													local farmId = vehicle:getOwnerFarmId();
													local farm = g_farmManager:getFarmById(farmId);
													local farmName = "Unknown Farm"
													local stateTxt = "?";
													if farm ~= nil then farmName = tostring(farm.name);end;
													if line.isContractorVehicle ~= nil and line.isContractorVehicle then
														g_currentMission.hlUtils.setBackgroundColor(overlay, g_currentMission.hlUtils.getColor("yellowGreen", true));
														stateTxt = g_i18n:getText("ui_on");
													else
														g_currentMission.hlUtils.setBackgroundColor(overlay, g_currentMission.hlUtils.getColor(box.overlays.color.warning, true));
														stateTxt = g_i18n:getText("ui_off");
													end;
													inIconArea = false;
													if inArea then inIconArea = overlay.mouseInArea();end;
													if inIconArea then
														setInfoHelpText(string.format(g_i18n:getText("box_contractorInfo"), farmName, stateTxt), 0);
													end;
													overlay:render();													
													lineWidth = lineWidth-iconWidthS-difW;
													nextLeftPosX = nextLeftPosX+iconWidthS+difW;
													canNextView = lineWidth > iconWidth;													
												end;
											end;
											--MP contractor info icon--
											--test view ad hud--
											if VehicleManager_Display.autoDrive.loaded and box.ownTable.view.adHudIcon[1] > 1 and VehicleManager_Display.firstPlayerControlled then --not g_currentMission.hlUtils.isControlledVehicle()
												if canNextView and line.isFarmVehicle and not line.isPlayer and not line.isOtherPlayer then
													overlay = overlayDefaultGroup[overlayDefaultByName["adIconOther"]];													
													if overlay ~= nil then
														local isAdHudActive = adc_SetGet:isAdHudActive(vehicle);
														g_currentMission.hlUtils.setOverlay(overlay, nextLeftPosX+difW, nextPosY, iconWidth, iconHeight);
														if adc_SetGet:isAdEditorMode() then
															g_currentMission.hlUtils.setBackgroundColor(overlay, g_currentMission.hlUtils.getColor("orangeRed", true));
														else
															g_currentMission.hlUtils.setBackgroundColor(overlay, g_currentMission.hlUtils.getColor("khaki", true));
														end;
														inIconArea = inArea and overlay.mouseInArea();
														if inIconArea then
															setInfoHelpText(g_i18n:getText("adHud_box_adHudIcon"), 0);
															if not g_currentMission.hlUtils:disableInArea() and inIconArea then box:setClickArea( {overlay.x, overlay.x+overlay.width, overlay.y, overlay.y+overlay.height, onClick=VehicleManager_Display_MouseKeyEventsBox.onClickArea, whatClick="VehicleManager_Display_Box", typPos=boxNumber, whereClick="adIcon_", ownTable={vehicleNode=line.node}} );end;
														end;
														local dropIcon = false;
														if isAdHudActive then
															if g_currentMission.hlUtils.runsTimer("1sec", true) then dropIcon = true;end;															
														else
															dropIcon = true;
														end;
														if dropIcon then overlay:render();end;													
														lineWidth = lineWidth-iconWidth-difW;
														nextLeftPosX = nextLeftPosX+iconWidth+difW;
														canNextView = lineWidth > iconWidth;
													end;
												end;
											end;
											--test view ad hud--
											isNextPosY = true;
										end;
										--VehilceName--	
										--vehicle preview/join line--
										if g_currentMission.hlUtils.modLoaded["FS25_VehicleInspector"] then											
											overlay = box.overlays.bgLine;
											if overlay ~= nil and inArea then
												g_currentMission.hlUtils.setOverlay(overlay, x+difW, nextPosY, x+w-difW, box.ownTable.lineHeight);
												inIconArea = overlay.mouseInArea();
												if box.ownTable.view.previewVehicles[1] > 1 then
													if not g_currentMission.hlUtils:disableInArea() and inIconArea then 
														g_currentMission.hlUtils.globalFunction["FS25_VehicleInspector"].setVehiclesPreviewData( {node=line.node, isTrain=false, isHorse=false} );
													end;
												end;
												--if not g_currentMission.hlUtils:disableInArea() and inIconArea then box:setClickArea( {overlay.x, overlay.x+overlay.width, overlay.y, overlay.y+overlay.height, onClick=VehicleManager_Display_MouseKeyEventsBox.onClickArea, whatClick="VehicleManager_Display_Box", typPos=boxNumber, whereClick="vehicleLine_", ownTable={vehicleNode=line.node}} );end;
											end;											
										end;
										--vehicle preview/join line--
									else
										text = g_currentMission.hlUtils.getTxtToWidth("Ghost Vehicle", size, lineWidth, false, ".");
										setTextColor(unpack(g_currentMission.hlUtils.getColor(box.overlays.color.warning, true)));
										renderText(nextLeftPosX, nextPosY, size, tostring(text));					
										setTextColor(1, 1, 1, 1);
										if not g_currentMission.hlUtils:disableInArea() and inArea then box:setClickArea( {nextLeftPosX, nextLeftPosX+lineWidth, nextPosY, nextPosY+box.ownTable.lineHeight, onClick=VehicleManager_Display_MouseKeyEventsBox.onClickArea, whatClick="VehicleManager_Display_Box", typPos=boxNumber, whereClick="ghostVehicle_", ownTable={vehicleNode=line.node,group=line.group,uGroup=line.uGroup,typId=line.typId}} );end;
										isNextPosY = true;
									end;
								end;							
							end;							
							------
							setNextPosY();
							------		
						else
							break;
						end;
					end;				
				elseif #VehicleManager_Display.viewGroupsBox == 0 then
					local moreTxt = "(".. tostring(g_i18n:getText("groups_notFound")).. ")";
					local text = g_currentMission.hlUtils.getTxtToWidth(tostring(g_i18n:getText("ui_none")).. moreTxt, size, lineWidth, false, ".");
					color = box.overlays.color.warning;
					setTextColor(unpack(g_currentMission.hlUtils.getColor(color, true)));
					renderText(nextLeftPosX, nextPosY, size, tostring(text));
					setTextColor(1, 1, 1, 1);
					local inIconArea = false;
					if inArea then inIconArea = getInIconArea(posX, posY, lineWidth, box.ownTable.lineHeight);end;
					if inIconArea then
						setInfoHelpText(g_i18n:getText("groups_firstStart"), 0, "yellow");
					end;
					if not g_currentMission.hlUtils:disableInArea() and inArea then box:setClickArea( {nextLeftPosX, nextLeftPosX+lineWidth, nextPosY, nextPosY+box.ownTable.lineHeight, onClick=VehicleManager_Display_MouseKeyEventsBox.onClickArea, whatClick="VehicleManager_Display_Box", typPos=boxNumber, whereClick="notFoundGroups_", ownTable={}} );end; --first start !
					break;
				end;				
			else --profile--
				if #profile > 0 then
					if profile[t] ~= nil then
						local profil = profile[t];
						color = g_currentMission.hlUtils.getColor(box.overlays.color.text, true);
						local profilName = tostring(profil.name);
						local displayName = tostring(profil.displayName);
						if displayName == nil then displayName = profilName;end;						
						if canNextView then
							if nextPosY > y then
								overlay = overlayDefaultGroup[overlayDefaultByName["copyPaste"]];
								if overlay ~= nil then
									g_currentMission.hlUtils.setOverlay(overlay,nextLeftPosX, nextPosY, iconWidthS, iconHeightS);
									local inIconArea = false;
									if inArea then inIconArea = overlay.mouseInArea();end;
									if not profil.active and inIconArea then 
										g_currentMission.hlUtils.setBackgroundColor(overlay, g_currentMission.hlUtils.getColor(box.overlays.color.inArea, true));										
									elseif profil.active then
										g_currentMission.hlUtils.setBackgroundColor(overlay, g_currentMission.hlUtils.getColor(box.overlays.color.notActive, true));
									elseif profil.newFile ~= nil and not profil.newFile then										
										g_currentMission.hlUtils.setBackgroundColor(overlay, g_currentMission.hlUtils.getColor(box.overlays.color.warning, true)); --old Save File										
									else
										g_currentMission.hlUtils.setBackgroundColor(overlay, g_currentMission.hlUtils.getColor(box.overlays.color.text, true));
									end;
									overlay:render();
									local moreTxt = "";
									local warningTxt = "";
									if #vmGroups.values.groups > 0 then warningTxt = "\n".. g_i18n:getText("profile_vorlage_copyPasteWarning");end;
									if profil.newFile ~= nil and not profil.newFile then moreTxt = "\n".. g_i18n:getText("profile_deleteOldFile");end;
									if inIconArea then
										if not profil.active then setInfoHelpText(string.format(g_i18n:getText("profile_copyPaste"), displayName).. warningTxt.. moreTxt, 0);else setInfoHelpText(string.format(g_i18n:getText("profile_active"), displayName), 0);end;										
									end;
									if not profil.active and not g_currentMission.hlUtils:disableInArea() and inArea and inIconArea then box:setClickArea( {overlay.x, overlay.x+overlay.width, overlay.y, overlay.y+overlay.height, onClick=VehicleManager_Display_MouseKeyEventsBox.onClickArea, whatClick="VehicleManager_Display_Box", typPos=boxNumber, whereClick="profilCopyPaste_", ownTable={profilName=profilName,isVorlage=false}} );end;
									lineWidth = lineWidth-iconWidth;
									nextLeftPosX = nextLeftPosX+iconWidth;
									canNextView = lineWidth > iconWidth;
									isNextPosY = true;	
								end;								
								if canNextView then
									text = g_currentMission.hlUtils.getTxtToWidth(displayName, size, lineWidth, false, ".");									
									if profil.active then color = g_currentMission.hlUtils.getColor(box.overlays.color.on, true);end;
									setTextColor(unpack(color));
									renderText(nextLeftPosX, nextPosY, size, tostring(text));					
									setTextColor(1, 1, 1, 1);
									local textWidth = getTextWidth(size, utf8Substr(text, 0));
									if box.isHelp and getInIconArea(nextLeftPosX, nil, lineWidth, nil) then
										local dirTxt = "../modSettings/HL/FS25_VehicleManagerDisplay/profile/";										
										if VehicleManager_Display:getHostOrSp() then
											dirTxt = "../savegame" .. g_currentMission.missionInfo.savegameIndex.. "/";
										end;
										setInfoHelpText(dirTxt.. "\n".. tostring(profilName).. ".xml", 2);
									end;
									if box.isSetting and not box.isHelp and not g_currentMission.hlUtils:disableInArea() and inArea then box:setClickArea( {nextLeftPosX, nextLeftPosX+textWidth, nextPosY, nextPosY+box.ownTable.lineHeight, onClick=VehicleManager_Display_MouseKeyEventsBox.onClickArea, whatClick="VehicleManager_Display_Box", typPos=boxNumber, whereClick="profilName_", ownTable={profilName=profilName,isVorlage=false}} );end;
									isNextPosY = true;
								end;
								
								------
								setNextPosY();
								------
							else
								break;
							end;
						end;
					end;
				end;
			end;
		end;
		--box lines--
	end;	
end;