VehicleManager_Display_DrawHud = {};

function VehicleManager_Display_DrawHud.setHud(args)
	if args == nil or type(args) ~= "table" or args.typPos == nil or args.inArea == nil then return;end;
	local hud = g_currentMission.hlHudSystem.hud[args.typPos];
	if hud == nil then return;end;
	local inArea = args.inArea
	local hudNumber = args.typPos;
	if hud.overlays.modIcons["VehicleManager_Display"] == nil or hud.overlays.modIcons["VehicleManager_Display"]["hud"] == nil then return;end; --check Mod Icons is loaded
	if not g_currentMission.hlHudSystem.isSetting.hud then hud.isSetting = false;end;
	
	local box = g_currentMission.hlHudSystem.hlBox:getData("VehicleManager_Display_Box");
	local showBox = box ~= nil and ((box.show and not box.autoClose) or (box.show and box.autoClose and g_currentMission.hlUtils.isMouseCursor));
	
	local x, y, w, h = hud:getScreen();
	
	local mW = w/2;
	local mH = h/2;
	
	local distance = hud:getSize( {"distance"} ); 
	local difW = distance.iconWidth --default width
	local difH = distance.iconHeight; --default height	
		
	local overlayGroup = hud.overlays.modIcons["VehicleManager_Display"]["hud"];
	local overlayByName = hud.overlays.modIcons.byName["VehicleManager_Display"]["hud"];
	local overlay = nil;	
	
	local txt = "VM";
	
	function needsUpdate()		
		if hud.needsUpdate or hud.ownTable.iconHeight == nil then			
			hud.ownTable.iconWidth, hud.ownTable.iconHeight = hud:getOptiWidthHeight( {typ="hud", height=h-(difH*2), width=w-difW} );
			hud.ownTable.optiSize, hud.ownTable.text = hud:getOptiSizeText( {typ="text", text=txt, cut=true, width=w-(difW*2), height=h-difH} );
			hud.ownTable.txtHeight = getTextHeight(hud.ownTable.optiSize, utf8Substr(hud.ownTable.text, 0));
		end;		
		hud.needsUpdate = false;
	end;	
	needsUpdate();
	
	local nextPosX = x;
	local nextPosY = y;
	local iconWidth = hud.ownTable.iconWidth;
	local iconHeight = hud.ownTable.iconHeight;
	local iconWidthS = iconWidth/2;
	local iconHeightS = iconHeight/2;
	local statePosY = y+h-iconHeight-difH;
	local statePercentWidth = (iconWidth-difW)/100;
	nextPosX = nextPosX+difW;		
	nextPosY = nextPosY+(h/2)-(iconHeight/2)-difH;
	if hud.ownTable.viewHudTyp == 1 then
		overlay = overlayGroup[overlayByName["vmBW"]];
	elseif hud.ownTable.viewHudTyp == 2 then
		overlay = overlayGroup[overlayByName["vmColor"]];
	end;
	function setInfo()
		local text = string.format(hud:getI18n("hl_infoDisplay_displayTypSwitch"), "HUD");
		if hud.ownTable.viewHudTyp > 2 then text = text.. "\n".. string.format(hud:getI18n("hl_infoDisplay_displayChangeSize"), "HUD", "Text", "Text");end;
		g_currentMission.hlHudSystem:addTextDisplay( {txt=tostring(text), maxLine=0} );		
	end;
		
	if overlay ~= nil then		
		g_currentMission.hlUtils.setOverlay(overlay, nextPosX, nextPosY, iconWidth, iconHeight);		
		if hud.ownTable.viewHudTyp == 1 then
			if inArea and overlay.mouseInArea() then 
				g_currentMission.hlUtils.setBackgroundColor(overlay, g_currentMission.hlUtils.getColor(hud.overlays.color.inArea, true));					
			else 				
				if showBox then 
					g_currentMission.hlUtils.setBackgroundColor(overlay, g_currentMission.hlUtils.getColor(hud.overlays.color.isShow, true));
				else
					g_currentMission.hlUtils.setBackgroundColor(overlay, g_currentMission.hlUtils.getColor(hud.overlays.color.txt, true));
				end;
			end;
		end;
		overlay:render();		
		
		if hud.isSetting and inArea and g_currentMission.hlHudSystem.infoDisplay.on then setInfo();end;
		if not g_currentMission.hlUtils:disableInArea() and not g_currentMission.hlHudSystem.isSetting.hud and inArea then hud:setClickArea( {overlay.x, overlay.x+overlay.width, overlay.y, overlay.y+overlay.height, whatClick="VehicleManager_Display_DrawHud", typPos=hudNumber, whereClick="vmDisplayIcon_", ownTable={}} );end;
	else
		--viewHudTyp 3 (Text)--
		setTextColor(1, 1, 1, 1);					
		setTextBold(true);
		if inArea then
			setTextColor(unpack(g_currentMission.hlUtils.getColor(hud.overlays.color.inArea, true)));
		else
			if showBox then 
				setTextColor(unpack(g_currentMission.hlUtils.getColor(hud.overlays.color.isShow, true)));
			else
				setTextColor(unpack(g_currentMission.hlUtils.getColor(hud.overlays.color.txt, true)));
			end;
		end;			
		renderText(x+difW, y+mH-(hud.ownTable.txtHeight/2)+difH, hud.ownTable.optiSize, tostring(hud.ownTable.text));
		setTextBold(false);
		setTextColor(1, 1, 1, 1);
		if hud.isSetting and inArea and g_currentMission.hlHudSystem.infoDisplay.on then setInfo();end;
		if not g_currentMission.hlUtils:disableInArea() and not g_currentMission.hlHudSystem.isSetting.hud and inArea then hud:setClickArea( {x, x+w, y, y+h, whatClick="VehicleManager_Display_DrawHud", typPos=hudNumber, whereClick="vmDisplayIcon_", ownTable={}} );end;
		--viewHudTyp 3 (Text)--
	end;
end;