VehicleManager_Display_XmlBox = {};

function VehicleManager_Display_XmlBox:defaultValues(box)
	box.ownTable = {updateList=false, lastStateExtraLine=false, autoProcesses={}, maxSettingTyp=3};
	box.ownTable.modus = {1,1,2,90}; --1 default, 2 insert delete vehicles,msg text warning timer
	box.ownTable.settingTyp = {1,1,3}; --off normal,groupsnames edit,profile edit
	box.ownTable.view = { --GuiBox
		isOpen = {false,6};
		driverActiveIcon = {1,1,2};
		vehicleAtGroupsIcon = {2,1,2};
		vehicleName = {2,1,5};
		combiVehicleName = {1,1,3};
		vehicleIcon = {2,1,3};
		folderLines = {2,1,2};
		previewVehicles = {1,1,2}; --needs VI (optinal option)
		adHudIcon={1,1,2};
	};
	box.ownTable.camera = {
		zoom = {18,5,30};
		rotX = {85,30,90};
		--rotY = {0,0,0};
		--rotZ = {0,0,0}
	};
	box.ownTable.viewText = {
		combiVehicleNameSeparator = "|";
		uGroupSeparator = "|";
	};	
	box.ownTable.showColors = {
		isOpen = {false,6};
		playerControlled = "ls15";
		otherControlled = "ls22";
		helperControlled = "darkGreen";
		unknownControlled = "darkYellow";
	};
end;

function VehicleManager_Display_XmlBox:onLoadXml(box, Xml, xmlNameTag)
	if box.ownTable.lastStateExtraLine == nil then VehicleManager_Display_XmlBox:defaultValues(box);end;	
	if Xml ~= nil and xmlNameTag ~= nil then	
		if getXMLInt(Xml, xmlNameTag.."#version") ~= nil then 
			
		else
			return; --first config not found
		end;
		
		--view--
		local groupNameTag = (xmlNameTag.. ".view(%d)"):format(0);
		for key, value in pairs (box.ownTable.view) do
			if key ~= "isOpen" and key ~= "adHudIcon" then
				if getXMLInt(Xml, groupNameTag.."#".. tostring(key)) ~= nil then box.ownTable.view[key][1] = getXMLInt(Xml, groupNameTag.."#".. tostring(key));end;				
			end;
		end;
		--view--
		--camera--
		groupNameTag = (xmlNameTag.. ".cameraBox(%d)"):format(0);
		for key, value in pairs (box.ownTable.camera) do
			if getXMLInt(Xml, groupNameTag.."#".. tostring(key)) ~= nil then box.ownTable.camera[key][1] = getXMLInt(Xml, groupNameTag.."#".. tostring(key));end;		
		end;
		--camera--
		--view text--
		groupNameTag = (xmlNameTag.. ".viewText(%d)"):format(0);
		for key, value in pairs (box.ownTable.viewText) do			
			if getXMLString(Xml, groupNameTag.."#".. tostring(key)) ~= nil then box.ownTable.viewText[key] = getXMLString(Xml, groupNameTag.."#".. tostring(key));end;			
		end;
		--view text--
		--show colors--
		--groupNameTag = (xmlNameTag.. ".showColors(%d)"):format(0);
		--for key, value in pairs (box.ownTable.showColors) do
		--	if key ~= "isOpen" then
		--		if getXMLString(Xml, groupNameTag.."#".. tostring(key)) ~= nil then 
		--			local color = getXMLString(Xml, groupNameTag.."#".. tostring(key));
		--			if g_currentMission.hlUtils.colorIntern[color] ~= nil then box.ownTable.showColors[key] = color;end;
		--		end;
		--	end;
		--end;
		--show colors--
	end;
end;

function VehicleManager_Display_XmlBox.onSaveXml(box, Xml, xmlNameTag)
	setXMLInt(Xml, xmlNameTag.."#version", VehicleManager_Display.metadata.xmlVersion);	
	
	--view--
	local groupNameTag = (xmlNameTag.. ".view(%d)"):format(0);
	for key, value in pairs (box.ownTable.view) do
		if key ~= "isOpen" then
			setXMLInt(Xml, groupNameTag.."#".. tostring(key), value[1]);
		end;
	end;
	--view--
	--camera--
	groupNameTag = (xmlNameTag.. ".cameraBox(%d)"):format(0);
	for key, value in pairs (box.ownTable.camera) do
		setXMLInt(Xml, groupNameTag.."#".. tostring(key), value[1]);
	end;
	--camera--
	--view text--
	groupNameTag = (xmlNameTag.. ".viewText(%d)"):format(0);
	for key, value in pairs (box.ownTable.viewText) do		
		setXMLString(Xml, groupNameTag.."#".. tostring(key), value);		
	end;
	--view text
	--show colors--
	groupNameTag = (xmlNameTag.. ".showColors(%d)"):format(0);
	for key, value in pairs (box.ownTable.showColors) do
		if key ~= "isOpen" then
			setXMLString(Xml, groupNameTag.."#".. tostring(key), value);
		end;
	end;
	--show colors--
	
	vmGroupsXml:saveProfil();
end;

function VehicleManager_Display_XmlBox:loadBox(name, show)
	if name == "VehicleManager_Display_Box" then
		local box = g_currentMission.hlHudSystem.hlBox.generate( {name=name, width=250, height=150, info="VehicleManager Mod\nVehicleManager Box", displayName="VehicleManagerDisplay Box", hiddenMod="VehicleManager", autoZoomOutIn="text"} );
		VehicleManager_DisplaySetGet:loadBoxIcons(box);
		box:setMinWidth(box.screen.pixelW*80); --set min. width new (default ..pixelW*30)
		box.onDraw = VehicleManager_Display_DrawBox.setBox;
		box.onClick = VehicleManager_Display_MouseKeyEventsBox.onClick;							
		box.screen.canBounds.on = true;
		box.resetBoundsByDragDrop = false;
		box.overlays.settingIcons.save.visible = false; --save over global icon
		box.overlays.settingIcons.up.visible = true; --for viewExtraLine
		box.overlays.settingIcons.down.visible = true; --for viewExtraLine
		box.isHelp = true;
		box.onSaveXml = VehicleManager_Display_XmlBox.onSaveXml;						
		VehicleManager_Display_XmlBox:onLoadXml(box, box:getXml()); --own box load over Xml (replace Data)
		box.displayName = "VehicleManagerDisplay Box" --fix DisplayName;
		box.autoZoomOutIn = "text"; --replace save xml value
		if show ~= nil and show and not box.show then box.show = true;end;
		box.ownTable.lastStateExtraLine = box.viewExtraLine;
		--setting Gui--
		vmGuiBoxSetGet:loadBox(box);
		--setting Gui--
	end;
end;