VehicleManager_Display_XmlHud = {};

function VehicleManager_Display_XmlHud:defaultValues(hud)
	hud.ownTable = {viewHudTyp=1, maxHudTyp=3};
end;

function VehicleManager_Display_XmlHud:onLoadXml(hud, Xml, xmlNameTag)
	if hud.ownTable.viewHudTyp == nil then VehicleManager_Display_XmlHud:defaultValues(hud);end;	
	if Xml ~= nil and xmlNameTag ~= nil then	
		if getXMLInt(Xml, xmlNameTag.."#version") ~= nil then 
						
		else
			return; --first config not found
		end;
		if getXMLInt(Xml, xmlNameTag.."#viewHudTyp") ~= nil then 
			hud.ownTable.viewHudTyp = getXMLInt(Xml, xmlNameTag.. "#viewHudTyp");
			if hud.ownTable.viewHudTyp > hud.ownTable.maxHudTyp or hud.ownTable.viewHudTyp < 1 then hud.ownTable.viewHudTyp = 1;end;
		end;			
	end;	
end;

function VehicleManager_Display_XmlHud.onSaveXml(hud, Xml, xmlNameTag)	
	setXMLInt(Xml, xmlNameTag.."#version", VehicleManager_Display.metadata.xmlVersion);
	setXMLInt(Xml, xmlNameTag.."#viewHudTyp", hud.ownTable.viewHudTyp);	
end;

function VehicleManager_Display_XmlHud:loadHud(name) 
	local hud = nil;
	if name == "VehicleManager_Display_Hud" then
		hud = g_currentMission.hlHudSystem.hlHud.generate( {name=name, width=40, info="VehicleManager Display Mod\n(VehicleManager Display)", displayName="VehicleManagerDisplay Hud", hiddenMod="VehicleManager", ownTable={}} ); --loadDefaultIcons=true	
		if hud ~= nil then			
			VehicleManager_DisplaySetGet:loadFillTypesIcons();
			VehicleManager_DisplaySetGet:loadHudIcons(hud);									
			hud.onDraw = VehicleManager_Display_DrawHud.setHud;
			hud.onClick = VehicleManager_Display_MouseKeyEventsHud.onClick;
			hud.onSaveXml = VehicleManager_Display_XmlHud.onSaveXml;						
			VehicleManager_Display_XmlHud:onLoadXml(hud, hud:getXml()); --own hud load over Xml
			hud.displayName = "MissionsDisplay Hud" --fix DisplayName;
			if hud.ownTable.viewHudTyp == 3 then hud.autoZoomOutIn = "text";else hud.autoZoomOutIn = "";end; --set text zoom is ...typ 1			
			if g_currentMission.hlHudSystem.isAlreadyExistsXml("box", "VehicleManager_Display_Box") then VehicleManager_Display_XmlBox:loadBox("VehicleManager_Display_Box", nil);end; --optional load
			return true;
		end;
	end;
	return false;
end;